/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.util;

import com.plotsquared.bukkit.entity.EntityWrapper;
import com.plotsquared.bukkit.entity.ReplicatingEntityWrapper;
import com.plotsquared.bukkit.util.BukkitChunkManager;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.location.PlotLoc;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.block.BaseBlock;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ContentMap {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + ContentMap.class.getSimpleName()));
    final Set<EntityWrapper> entities = new HashSet<EntityWrapper>();
    final Map<PlotLoc, BaseBlock[]> allBlocks = new HashMap<PlotLoc, BaseBlock[]>();

    ContentMap() {
    }

    public void saveRegion(BukkitWorld world, int x1, int x2, int z1, int z2) {
        int tmp;
        if (z1 > z2) {
            tmp = z1;
            z1 = z2;
            z2 = tmp;
        }
        if (x1 > x2) {
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        for (int x = x1; x <= x2; ++x) {
            for (int z = z1; z <= z2; ++z) {
                this.saveBlocks(world, x, z);
            }
        }
    }

    void saveEntitiesOut(Chunk chunk, CuboidRegion region) {
        for (Entity entity : chunk.getEntities()) {
            int z;
            Location location = BukkitUtil.adapt(entity.getLocation());
            int x = location.getX();
            if (BukkitChunkManager.isIn(region, x, z = location.getZ()) || entity.getVehicle() != null) continue;
            ReplicatingEntityWrapper wrap = new ReplicatingEntityWrapper(entity, 2);
            ((EntityWrapper)wrap).saveEntity();
            this.entities.add(wrap);
        }
    }

    void saveEntitiesIn(Chunk chunk, CuboidRegion region, boolean delete) {
        for (Entity entity : chunk.getEntities()) {
            int z;
            Location location = BukkitUtil.adapt(entity.getLocation());
            int x = location.getX();
            if (!BukkitChunkManager.isIn(region, x, z = location.getZ()) || entity.getVehicle() != null) continue;
            ReplicatingEntityWrapper wrap = new ReplicatingEntityWrapper(entity, 2);
            ((EntityWrapper)wrap).saveEntity();
            this.entities.add(wrap);
            if (!delete || entity instanceof Player) continue;
            entity.remove();
        }
    }

    void restoreEntities(World world) {
        for (EntityWrapper entity : this.entities) {
            try {
                entity.spawn(world, 0, 0);
            }
            catch (Exception e) {
                LOGGER.error("Failed to restore entity", (Throwable)e);
            }
        }
        this.entities.clear();
    }

    private void saveBlocks(BukkitWorld world, int x, int z) {
        BaseBlock[] ids = new BaseBlock[world.getMaxY() - world.getMinY() + 1];
        for (int yIndex = 0; yIndex <= world.getMaxY() - world.getMinY(); yIndex = (int)((short)(yIndex + 1))) {
            BaseBlock block;
            ids[yIndex] = block = world.getFullBlock(BlockVector3.at((int)x, (int)(yIndex + world.getMinY()), (int)z));
        }
        PlotLoc loc = new PlotLoc(x, z);
        this.allBlocks.put(loc, ids);
    }
}

