/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.queue;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.plotsquared.bukkit.BukkitPlatform;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.queue.ChunkCoordinator;
import com.plotsquared.core.queue.subscriber.ProgressSubscriber;
import com.plotsquared.core.util.task.PlotSquaredTask;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.world.World;
import io.papermc.lib.PaperLib;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class BukkitChunkCoordinator
extends ChunkCoordinator {
    private final List<ProgressSubscriber> progressSubscribers = new LinkedList<ProgressSubscriber>();
    private final Queue<BlockVector2> requestedChunks;
    private final Queue<Chunk> availableChunks;
    private final long maxIterationTime;
    private final Plugin plugin;
    private final Consumer<BlockVector2> chunkConsumer;
    private final org.bukkit.World bukkitWorld;
    private final Runnable whenDone;
    private final Consumer<Throwable> throwableConsumer;
    private final boolean unloadAfter;
    private final int totalSize;
    private final AtomicInteger expectedSize;
    private final AtomicInteger loadingChunks = new AtomicInteger();
    private final boolean forceSync;
    private int batchSize;
    private PlotSquaredTask task;
    private volatile boolean shouldCancel;
    private boolean finished;

    @Inject
    private BukkitChunkCoordinator(@Assisted long maxIterationTime, @Assisted int initialBatchSize, @Assisted @NonNull Consumer<BlockVector2> chunkConsumer, @Assisted @NonNull World world, @Assisted @NonNull Collection<BlockVector2> requestedChunks, @Assisted @NonNull Runnable whenDone, @Assisted @NonNull Consumer<Throwable> throwableConsumer, @Assisted(value="unloadAfter") boolean unloadAfter, @Assisted @NonNull Collection<ProgressSubscriber> progressSubscribers, @Assisted(value="forceSync") boolean forceSync) {
        this.requestedChunks = new LinkedBlockingQueue<BlockVector2>(requestedChunks);
        this.availableChunks = new LinkedBlockingQueue<Chunk>();
        this.totalSize = requestedChunks.size();
        this.expectedSize = new AtomicInteger(this.totalSize);
        this.batchSize = initialBatchSize;
        this.chunkConsumer = chunkConsumer;
        this.maxIterationTime = maxIterationTime;
        this.whenDone = whenDone;
        this.throwableConsumer = throwableConsumer;
        this.unloadAfter = unloadAfter;
        this.plugin = JavaPlugin.getPlugin(BukkitPlatform.class);
        this.bukkitWorld = Bukkit.getWorld((String)world.getName());
        this.progressSubscribers.addAll(progressSubscribers);
        this.forceSync = forceSync;
    }

    public void start() {
        if (!this.forceSync) {
            this.requestBatch();
            TaskManager.runTaskLater(() -> {
                this.task = TaskManager.runTaskRepeat((Runnable)((Object)this), (TaskTime)TaskTime.ticks((long)1L));
            }, (TaskTime)TaskTime.ticks((long)1L));
        } else {
            try {
                while (!this.shouldCancel && !this.requestedChunks.isEmpty()) {
                    this.chunkConsumer.accept(this.requestedChunks.poll());
                }
            }
            catch (Throwable t) {
                this.throwableConsumer.accept(t);
            }
            finally {
                this.finish();
            }
        }
    }

    public void cancel() {
        this.shouldCancel = true;
    }

    private void finish() {
        try {
            this.whenDone.run();
        }
        catch (Throwable throwable) {
            this.throwableConsumer.accept(throwable);
        }
        finally {
            for (ProgressSubscriber subscriber : this.progressSubscribers) {
                subscriber.notifyEnd();
            }
            if (this.task != null) {
                this.task.cancel();
            }
            this.finished = true;
        }
    }

    public void run() {
        int expected;
        if (this.shouldCancel) {
            if (this.unloadAfter) {
                Chunk chunk;
                while ((chunk = this.availableChunks.poll()) != null) {
                    this.freeChunk(chunk);
                }
            }
            this.finish();
            return;
        }
        Chunk chunk = this.availableChunks.poll();
        if (chunk == null) {
            if (this.availableChunks.isEmpty()) {
                if (this.requestedChunks.isEmpty() && this.loadingChunks.get() == 0) {
                    this.finish();
                } else {
                    this.requestBatch();
                }
            }
            return;
        }
        long[] iterationTime = new long[2];
        int processedChunks = 0;
        do {
            long start = System.currentTimeMillis();
            try {
                this.chunkConsumer.accept(BlockVector2.at((int)chunk.getX(), (int)chunk.getZ()));
            }
            catch (Throwable throwable) {
                this.throwableConsumer.accept(throwable);
            }
            if (this.unloadAfter) {
                this.freeChunk(chunk);
            }
            ++processedChunks;
            long end = System.currentTimeMillis();
            iterationTime[0] = iterationTime[1];
            iterationTime[1] = end - start;
        } while (iterationTime[0] + iterationTime[1] < this.maxIterationTime * 2L && (chunk = this.availableChunks.poll()) != null);
        if (processedChunks < this.batchSize) {
            this.batchSize = processedChunks;
        }
        if ((expected = this.expectedSize.addAndGet(-processedChunks)) <= 0) {
            this.finish();
        } else if (this.availableChunks.size() < processedChunks) {
            double progress = ((double)this.totalSize - (double)expected) / (double)this.totalSize;
            for (ProgressSubscriber subscriber : this.progressSubscribers) {
                subscriber.notifyProgress((ChunkCoordinator)this, progress);
            }
            this.requestBatch();
        }
    }

    private void requestBatch() {
        BlockVector2 chunk;
        for (int i = 0; i < this.batchSize && (chunk = this.requestedChunks.poll()) != null; ++i) {
            this.loadingChunks.incrementAndGet();
            PaperLib.getChunkAtAsync((org.bukkit.World)this.bukkitWorld, (int)chunk.getX(), (int)chunk.getZ(), (boolean)true, (boolean)true).whenComplete((chunkObject, throwable) -> {
                this.loadingChunks.decrementAndGet();
                if (throwable != null) {
                    throwable.printStackTrace();
                    this.expectedSize.decrementAndGet();
                } else if (PlotSquared.get().isMainThread(Thread.currentThread())) {
                    this.processChunk((Chunk)chunkObject);
                } else {
                    TaskManager.runTask(() -> this.processChunk((Chunk)chunkObject));
                }
            });
        }
    }

    private void processChunk(@NonNull Chunk chunk) {
        if (this.finished) {
            return;
        }
        chunk.addPluginChunkTicket(this.plugin);
        this.availableChunks.add(chunk);
    }

    private void freeChunk(@NonNull Chunk chunk) {
        if (!chunk.isLoaded()) {
            throw new IllegalArgumentException(String.format("Chunk %d;%d is is not loaded", chunk.getX(), chunk.getZ()));
        }
        chunk.removePluginChunkTicket(this.plugin);
    }

    public int getRemainingChunks() {
        return this.expectedSize.get();
    }

    public int getTotalChunks() {
        return this.totalSize;
    }

    public void subscribeToProgress(@NonNull ProgressSubscriber subscriber) {
        this.progressSubscribers.add(subscriber);
    }
}

