/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.flag.implementations.EditSignFlag;
import com.plotsquared.core.util.PlotFlagUtil;
import org.bukkit.block.Sign;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerSignOpenEvent;

public class PlayerEventListener1201
implements Listener {
    @EventHandler(ignoreCancelled=true)
    public void onPlayerSignOpenEvent(PlayerSignOpenEvent event) {
        Sign sign = event.getSign();
        Location location = BukkitUtil.adapt(sign.getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null) {
            if (PlotFlagUtil.isAreaRoadFlagsAndFlagEquals((PlotArea)area, EditSignFlag.class, (Object)false) && !event.getPlayer().hasPermission(Permission.PERMISSION_ADMIN_INTERACT_ROAD.toString())) {
                event.setCancelled(true);
            }
            return;
        }
        if (plot.isAdded(event.getPlayer().getUniqueId())) {
            return;
        }
        if (!((Boolean)plot.getFlag(EditSignFlag.class)).booleanValue() && !event.getPlayer().hasPermission(Permission.PERMISSION_ADMIN_INTERACT_OTHER.toString())) {
            plot.debug(event.getPlayer().getName() + " could not edit the sign because of edit-sign = false");
            event.setCancelled(true);
        }
    }
}

