/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.inject;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.plotsquared.bukkit.BukkitPlatform;
import com.plotsquared.bukkit.listener.ServerListener;
import com.plotsquared.bukkit.listener.SingleWorldListener;
import com.plotsquared.bukkit.player.BukkitPlayerManager;
import com.plotsquared.bukkit.queue.BukkitChunkCoordinator;
import com.plotsquared.bukkit.queue.BukkitQueueCoordinator;
import com.plotsquared.bukkit.schematic.BukkitSchematicHandler;
import com.plotsquared.bukkit.util.BukkitChunkManager;
import com.plotsquared.bukkit.util.BukkitInventoryUtil;
import com.plotsquared.bukkit.util.BukkitRegionManager;
import com.plotsquared.bukkit.util.BukkitSetupUtils;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.bukkit.util.fawe.FaweRegionManager;
import com.plotsquared.bukkit.util.fawe.FaweSchematicHandler;
import com.plotsquared.core.PlotPlatform;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.generator.HybridGen;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.inject.annotations.ConsoleActor;
import com.plotsquared.core.inject.annotations.DefaultGenerator;
import com.plotsquared.core.inject.factory.ChunkCoordinatorBuilderFactory;
import com.plotsquared.core.inject.factory.ChunkCoordinatorFactory;
import com.plotsquared.core.inject.factory.HybridPlotWorldFactory;
import com.plotsquared.core.inject.factory.ProgressSubscriberFactory;
import com.plotsquared.core.player.OfflinePlotPlayer;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.world.DefaultPlotAreaManager;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlotAreaManager;
import com.plotsquared.core.queue.ChunkCoordinator;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.queue.QueueProvider;
import com.plotsquared.core.queue.subscriber.DefaultProgressSubscriber;
import com.plotsquared.core.queue.subscriber.ProgressSubscriber;
import com.plotsquared.core.util.ChunkManager;
import com.plotsquared.core.util.EconHandler;
import com.plotsquared.core.util.InventoryUtil;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.RegionManager;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.core.util.SetupUtils;
import com.plotsquared.core.util.WorldUtil;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.extension.platform.Actor;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BukkitModule
extends AbstractModule {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + BukkitModule.class.getSimpleName()));
    private final BukkitPlatform bukkitPlatform;

    public BukkitModule(@NonNull BukkitPlatform bukkitPlatform) {
        this.bukkitPlatform = bukkitPlatform;
    }

    protected void configure() {
        this.bind(PlayerManager.class).to(BukkitPlayerManager.class);
        this.bind(JavaPlugin.class).toInstance((Object)this.bukkitPlatform);
        this.bind(PlotPlatform.class).toInstance((Object)this.bukkitPlatform);
        this.bind(BukkitPlatform.class).toInstance((Object)this.bukkitPlatform);
        this.bind(IndependentPlotGenerator.class).annotatedWith(DefaultGenerator.class).to(HybridGen.class);
        @NonNull ConsoleCommandSender console = Bukkit.getServer().getConsoleSender();
        WorldEditPlugin wePlugin = (WorldEditPlugin)Bukkit.getPluginManager().getPlugin("WorldEdit");
        this.bind(Actor.class).annotatedWith(ConsoleActor.class).toInstance((Object)wePlugin.wrapCommandSender((CommandSender)console));
        this.bind(InventoryUtil.class).to(BukkitInventoryUtil.class);
        this.bind(SetupUtils.class).to(BukkitSetupUtils.class);
        this.bind(WorldUtil.class).to(BukkitUtil.class);
        this.install(new FactoryModuleBuilder().implement(ProgressSubscriber.class, DefaultProgressSubscriber.class).build(ProgressSubscriberFactory.class));
        this.bind(ChunkManager.class).to(BukkitChunkManager.class);
        if (PlotSquared.platform().isFaweHooking()) {
            this.bind(SchematicHandler.class).to(FaweSchematicHandler.class);
            this.bind(RegionManager.class).to(FaweRegionManager.class);
        } else {
            this.bind(SchematicHandler.class).to(BukkitSchematicHandler.class);
            this.bind(RegionManager.class).to(BukkitRegionManager.class);
        }
        this.bind(GlobalBlockQueue.class).toInstance((Object)new GlobalBlockQueue(QueueProvider.of(BukkitQueueCoordinator.class)));
        if (Settings.Enabled_Components.WORLDS) {
            this.bind(PlotAreaManager.class).to(SinglePlotAreaManager.class);
            try {
                this.bind(SingleWorldListener.class).toInstance((Object)new SingleWorldListener());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.bind(PlotAreaManager.class).to(DefaultPlotAreaManager.class);
        }
        this.install(new FactoryModuleBuilder().build(HybridPlotWorldFactory.class));
        this.install(new FactoryModuleBuilder().implement(ChunkCoordinator.class, BukkitChunkCoordinator.class).build(ChunkCoordinatorFactory.class));
        this.install(new FactoryModuleBuilder().build(ChunkCoordinatorBuilderFactory.class));
    }

    @Provides
    @Singleton
    @NonNull EconHandler provideEconHandler() {
        if (!Settings.Enabled_Components.ECONOMY || !Bukkit.getPluginManager().isPluginEnabled("Vault")) {
            return EconHandler.nullEconHandler();
        }
        return new LazyEconHandler();
    }

    private static final class LazyEconHandler
    extends EconHandler
    implements ServerListener.MutableEconHandler {
        private volatile EconHandler implementation;

        private LazyEconHandler() {
        }

        @Override
        public void setImplementation(EconHandler econHandler) {
            this.implementation = econHandler;
        }

        public boolean init() {
            return this.get().init();
        }

        public double getBalance(PlotPlayer<?> player) {
            return this.get().getBalance(player);
        }

        public void withdrawMoney(PlotPlayer<?> player, double amount) {
            this.get().withdrawMoney(player, amount);
        }

        public void depositMoney(PlotPlayer<?> player, double amount) {
            this.get().depositMoney(player, amount);
        }

        public void depositMoney(OfflinePlotPlayer player, double amount) {
            this.get().depositMoney(player, amount);
        }

        public boolean isEnabled(PlotArea plotArea) {
            return this.get().isEnabled(plotArea);
        }

        public @NonNull String format(double balance) {
            return this.get().format(balance);
        }

        public boolean isSupported() {
            return this.get().isSupported();
        }

        private EconHandler get() {
            return Objects.requireNonNull(this.implementation, "EconHandler not ready yet.");
        }
    }
}

