/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.generator;

import com.plotsquared.bukkit.queue.LimitedRegionWrapperQueue;
import com.plotsquared.core.generator.HybridPlotWorld;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.location.UncheckedWorldLocation;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.queue.ZeroedDelegateScopedQueueCoordinator;
import java.util.Random;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.checkerframework.checker.nullness.qual.NonNull;

final class BlockStatePopulator
extends BlockPopulator {
    private final IndependentPlotGenerator plotGenerator;

    public BlockStatePopulator(@NonNull IndependentPlotGenerator plotGenerator) {
        this.plotGenerator = plotGenerator;
    }

    public void populate(@NonNull WorldInfo worldInfo, @NonNull Random random, int chunkX, int chunkZ, @NonNull LimitedRegion limitedRegion) {
        HybridPlotWorld hpw;
        PlotArea area = UncheckedWorldLocation.at((String)worldInfo.getName(), (int)(chunkX << 4), (int)0, (int)(chunkZ << 4)).getPlotArea();
        if (area == null || area instanceof HybridPlotWorld && !(hpw = (HybridPlotWorld)area).populationNeeded() || area instanceof SinglePlotArea) {
            return;
        }
        LimitedRegionWrapperQueue wrapped = new LimitedRegionWrapperQueue(limitedRegion);
        UncheckedWorldLocation min = UncheckedWorldLocation.at((String)worldInfo.getName(), (int)(chunkX << 4), (int)worldInfo.getMinHeight(), (int)(chunkZ << 4));
        UncheckedWorldLocation max = UncheckedWorldLocation.at((String)worldInfo.getName(), (int)((chunkX << 4) + 15), (int)worldInfo.getMaxHeight(), (int)((chunkZ << 4) + 15));
        ZeroedDelegateScopedQueueCoordinator offsetChunkQueue = new ZeroedDelegateScopedQueueCoordinator((QueueCoordinator)wrapped, (Location)min, (Location)max);
        this.plotGenerator.populateChunk(offsetChunkQueue, area);
    }
}

