/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.plotsquared.bukkit.BukkitCommand;
import com.plotsquared.bukkit.generator.BukkitPlotGenerator;
import com.plotsquared.bukkit.inject.BackupModule;
import com.plotsquared.bukkit.inject.BukkitModule;
import com.plotsquared.bukkit.inject.PermissionModule;
import com.plotsquared.bukkit.inject.WorldManagerModule;
import com.plotsquared.bukkit.listener.BlockEventListener;
import com.plotsquared.bukkit.listener.BlockEventListener117;
import com.plotsquared.bukkit.listener.ChunkListener;
import com.plotsquared.bukkit.listener.EntityEventListener;
import com.plotsquared.bukkit.listener.EntitySpawnListener;
import com.plotsquared.bukkit.listener.PaperListener;
import com.plotsquared.bukkit.listener.PlayerEventListener;
import com.plotsquared.bukkit.listener.ProjectileEventListener;
import com.plotsquared.bukkit.listener.ServerListener;
import com.plotsquared.bukkit.listener.SingleWorldListener;
import com.plotsquared.bukkit.listener.SpigotListener;
import com.plotsquared.bukkit.listener.WorldEvents;
import com.plotsquared.bukkit.placeholder.PAPIPlaceholders;
import com.plotsquared.bukkit.placeholder.PlaceholderFormatter;
import com.plotsquared.bukkit.player.BukkitPlayerManager;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.bukkit.util.BukkitWorld;
import com.plotsquared.bukkit.util.SetGenCB;
import com.plotsquared.bukkit.util.TranslationUpdateManager;
import com.plotsquared.bukkit.util.UpdateUtility;
import com.plotsquared.bukkit.util.task.BukkitTaskManager;
import com.plotsquared.bukkit.util.task.PaperTimeConverter;
import com.plotsquared.bukkit.util.task.SpigotTimeConverter;
import com.plotsquared.bukkit.uuid.EssentialsUUIDService;
import com.plotsquared.bukkit.uuid.LuckPermsUUIDService;
import com.plotsquared.bukkit.uuid.OfflinePlayerUUIDService;
import com.plotsquared.bukkit.uuid.PaperUUIDService;
import com.plotsquared.bukkit.uuid.SQLiteUUIDService;
import com.plotsquared.bukkit.uuid.SquirrelIdUUIDService;
import com.plotsquared.core.PlotPlatform;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.backup.BackupManager;
import com.plotsquared.core.components.ComponentPresetManager;
import com.plotsquared.core.configuration.ConfigurationNode;
import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.configuration.ConfigurationUtil;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.Storage;
import com.plotsquared.core.configuration.caption.ChatFormatter;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.events.RemoveRoadEntityEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.generator.GeneratorWrapper;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.generator.SingleWorldGenerator;
import com.plotsquared.core.inject.annotations.BackgroundPipeline;
import com.plotsquared.core.inject.annotations.DefaultGenerator;
import com.plotsquared.core.inject.annotations.ImpromptuPipeline;
import com.plotsquared.core.inject.annotations.WorldConfig;
import com.plotsquared.core.inject.annotations.WorldFile;
import com.plotsquared.core.inject.modules.PlotSquaredModule;
import com.plotsquared.core.listener.PlotListener;
import com.plotsquared.core.listener.WESubscriber;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.location.World;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotAreaTerrainType;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.comment.CommentManager;
import com.plotsquared.core.plot.flag.implementations.ServerPlotFlag;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.plot.world.SinglePlotAreaManager;
import com.plotsquared.core.setup.PlotAreaBuilder;
import com.plotsquared.core.setup.SettingsNodesWrapper;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.FileUtils;
import com.plotsquared.core.util.PlatformWorldManager;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.PremiumVerification;
import com.plotsquared.core.util.ReflectionUtils;
import com.plotsquared.core.util.SetupUtils;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.plotsquared.core.uuid.CacheUUIDService;
import com.plotsquared.core.uuid.UUIDPipeline;
import com.plotsquared.core.uuid.UUIDService;
import com.plotsquared.core.uuid.offline.OfflineModeUUIDService;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import io.papermc.lib.PaperLib;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bstats.bukkit.Metrics;
import org.bstats.charts.CustomChart;
import org.bstats.charts.DrilldownPie;
import org.bstats.charts.SimplePie;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.incendo.serverlib.ServerLib;

@Singleton
public final class BukkitPlatform
extends JavaPlugin
implements Listener,
PlotPlatform<Player> {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + BukkitPlatform.class.getSimpleName()));
    private static final int BSTATS_ID = 1404;
    private int[] version;
    private String pluginName;
    private SingleWorldListener singleWorldListener;
    private Method methodUnloadChunk0;
    private boolean methodUnloadSetup = false;
    private boolean metricsStarted;
    private boolean faweHook = false;
    private Injector injector;
    @Inject
    private PlotAreaManager plotAreaManager;
    @Inject
    private EventDispatcher eventDispatcher;
    @Inject
    private PlotListener plotListener;
    @Inject
    @WorldConfig
    private YamlConfiguration worldConfiguration;
    @Inject
    @WorldFile
    private File worldfile;
    @Inject
    private BukkitPlayerManager playerManager;
    @Inject
    private BackupManager backupManager;
    @Inject
    @ImpromptuPipeline
    private UUIDPipeline impromptuPipeline;
    @Inject
    @BackgroundPipeline
    private UUIDPipeline backgroundPipeline;
    @Inject
    private PlatformWorldManager<org.bukkit.World> worldManager;
    private Locale serverLocale;

    public int @NonNull [] serverVersion() {
        if (this.version == null) {
            try {
                this.version = new int[3];
                String[] split = Bukkit.getBukkitVersion().split("-")[0].split("\\.");
                this.version[0] = Integer.parseInt(split[0]);
                this.version[1] = Integer.parseInt(split[1]);
                if (split.length == 3) {
                    this.version[2] = Integer.parseInt(split[2]);
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return new int[]{1, 13, 0};
            }
        }
        return this.version;
    }

    public int versionMinHeight() {
        return this.serverVersion()[1] >= 18 ? -64 : 0;
    }

    public int versionMaxHeight() {
        return this.serverVersion()[1] >= 18 ? 319 : 255;
    }

    public @NonNull String serverImplementation() {
        return Bukkit.getVersion();
    }

    public void onEnable() {
        EssentialsUUIDService essentialsUUIDService;
        LuckPermsUUIDService luckPermsUUIDService;
        Plugin fawe;
        this.pluginName = this.getDescription().getName();
        Object timeConverter = PaperLib.isPaper() ? new PaperTimeConverter() : new SpigotTimeConverter();
        PlotPlayer.registerConverter(Player.class, BukkitUtil::adapt);
        TaskManager.setPlatformImplementation((TaskManager)new BukkitTaskManager(this, (TaskTime.TimeConverter)timeConverter));
        PlotSquared plotSquared = new PlotSquared((PlotPlatform)this, "Bukkit");
        if (Settings.FAWE_Components.FAWE_HOOK && (fawe = this.getServer().getPluginManager().getPlugin("FastAsyncWorldEdit")) != null) {
            try {
                Class.forName("com.fastasyncworldedit.bukkit.regions.plotsquared.FaweQueueCoordinator");
                this.faweHook = true;
            }
            catch (Exception ignored) {
                LOGGER.error("Incompatible version of FastAsyncWorldEdit to enable hook, please upgrade: https://ci.athion.net/job/FastAsyncWorldEdit/");
            }
        }
        this.injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new PermissionModule(), new WorldManagerModule(), new PlotSquaredModule(), new BukkitModule(this), new BackupModule()});
        this.injector.injectMembers((Object)this);
        try {
            TranslationUpdateManager cfr_ignored_0 = (TranslationUpdateManager)this.injector.getInstance(TranslationUpdateManager.class);
            TranslationUpdateManager.upgradeTranslationFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.serverLocale = Locale.forLanguageTag(Settings.Enabled_Components.DEFAULT_LOCALE);
        if (PremiumVerification.isPremium().booleanValue() && Settings.Enabled_Components.UPDATE_NOTIFICATIONS) {
            ((UpdateUtility)this.injector.getInstance(UpdateUtility.class)).updateChecker();
        }
        if (PremiumVerification.isPremium().booleanValue()) {
            LOGGER.info("PlotSquared version licensed to Spigot user {}", (Object)PremiumVerification.getUserID());
            LOGGER.info("https://www.spigotmc.org/resources/{}", (Object)PremiumVerification.getResourceID());
            LOGGER.info("Download ID: {}", (Object)PremiumVerification.getDownloadID());
            LOGGER.info("Thanks for supporting us :)");
        } else {
            LOGGER.info("Couldn't verify purchase :(");
        }
        if (Settings.Enabled_Components.DATABASE) {
            plotSquared.setupDatabase();
        }
        if (!plotSquared.getConfigurationVersion().equalsIgnoreCase("v5") && DBFunc.dbManager.convertFlags()) {
            LOGGER.info("Flags were converted successfully!");
            try {
                plotSquared.setConfigurationVersion("v5");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        CommentManager.registerDefaultInboxes();
        if (Settings.Enabled_Components.KILL_ROAD_MOBS || Settings.Enabled_Components.KILL_ROAD_VEHICLES) {
            this.runEntityTask();
        }
        if (Settings.Enabled_Components.WORLDEDIT_RESTRICTIONS) {
            try {
                WorldEdit.getInstance().getEventBus().register(this.injector().getInstance(WESubscriber.class));
                LOGGER.info("{} hooked into WorldEdit", (Object)this.pluginName());
            }
            catch (Throwable e) {
                LOGGER.error("Incompatible version of WorldEdit, please upgrade: https://builds.enginehub.org/job/worldedit?branch=master");
            }
        }
        if (Settings.Enabled_Components.EVENTS) {
            this.getServer().getPluginManager().registerEvents((Listener)this.injector().getInstance(PlayerEventListener.class), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)this.injector().getInstance(BlockEventListener.class), (Plugin)this);
            if (this.serverVersion()[1] >= 17) {
                this.getServer().getPluginManager().registerEvents((Listener)this.injector().getInstance(BlockEventListener117.class), (Plugin)this);
            }
            this.getServer().getPluginManager().registerEvents((Listener)this.injector().getInstance(EntityEventListener.class), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)this.injector().getInstance(ProjectileEventListener.class), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)this.injector().getInstance(ServerListener.class), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)this.injector().getInstance(EntitySpawnListener.class), (Plugin)this);
            if (PaperLib.isPaper() && Settings.Paper_Components.PAPER_LISTENERS) {
                this.getServer().getPluginManager().registerEvents((Listener)this.injector().getInstance(PaperListener.class), (Plugin)this);
            } else {
                this.getServer().getPluginManager().registerEvents((Listener)this.injector().getInstance(SpigotListener.class), (Plugin)this);
            }
            this.plotListener.startRunnable();
        }
        this.getServer().getPluginManager().registerEvents((Listener)this.injector().getInstance(WorldEvents.class), (Plugin)this);
        if (Settings.Enabled_Components.CHUNK_PROCESSOR) {
            this.getServer().getPluginManager().registerEvents((Listener)this.injector().getInstance(ChunkListener.class), (Plugin)this);
        }
        if (Settings.Enabled_Components.COMMANDS) {
            this.registerCommands();
        }
        this.permissionHandler().initialize();
        if (Settings.Enabled_Components.COMPONENT_PRESETS) {
            try {
                this.injector().getInstance(ComponentPresetManager.class);
            }
            catch (Exception e) {
                LOGGER.error("Failed to initialize the preset system", (Throwable)e);
            }
        }
        ConfigurationSection section = this.worldConfiguration.getConfigurationSection("worlds");
        WorldUtil worldUtil = (WorldUtil)this.injector().getInstance(WorldUtil.class);
        if (section != null) {
            for (String world : section.getKeys(false)) {
                if (world.equals("CheckingPlotSquaredGenerator") || !worldUtil.isWorld(world)) continue;
                this.setGenerator(world);
            }
            TaskManager.runTaskLater(() -> {
                for (String world : section.getKeys(false)) {
                    if (world.equals("CheckingPlotSquaredGenerator") || worldUtil.isWorld(world) || world.equals("*")) continue;
                    if (Settings.DEBUG) {
                        LOGGER.warn("`{}` was not properly loaded - {} will now try to load it properly", (Object)world, (Object)this.pluginName());
                        LOGGER.warn("- Are you trying to delete this world? Remember to remove it from the worlds.yml, bukkit.yml and multiverse worlds.yml");
                        LOGGER.warn("- Your world management plugin may be faulty (or non existent)");
                        LOGGER.warn("- The named world is not a plot world");
                        LOGGER.warn("This message may also be a false positive and could be ignored.");
                    }
                    this.setGenerator(world);
                }
            }, (TaskTime)TaskTime.ticks((long)1L));
        }
        plotSquared.startExpiryTasks();
        TaskManager.runTaskLater(() -> PlotSquared.platform().setupUtils().updateGenerators(true), (TaskTime)TaskTime.ticks((long)1L));
        CacheUUIDService cacheUUIDService = new CacheUUIDService(Settings.UUID.UUID_CACHE_SIZE);
        this.impromptuPipeline.registerService((UUIDService)cacheUUIDService);
        this.backgroundPipeline.registerService((UUIDService)cacheUUIDService);
        this.impromptuPipeline.registerConsumer((Consumer)cacheUUIDService);
        this.backgroundPipeline.registerConsumer((Consumer)cacheUUIDService);
        if (Settings.UUID.OFFLINE) {
            OfflineModeUUIDService offlineModeUUIDService = new OfflineModeUUIDService();
            this.impromptuPipeline.registerService((UUIDService)offlineModeUUIDService);
            this.backgroundPipeline.registerService((UUIDService)offlineModeUUIDService);
            LOGGER.info("(UUID) Using the offline mode UUID service");
        }
        if (Settings.UUID.SERVICE_BUKKIT) {
            OfflinePlayerUUIDService offlinePlayerUUIDService = new OfflinePlayerUUIDService();
            this.impromptuPipeline.registerService((UUIDService)offlinePlayerUUIDService);
            this.backgroundPipeline.registerService((UUIDService)offlinePlayerUUIDService);
        }
        SQLiteUUIDService sqLiteUUIDService = new SQLiteUUIDService("user_cache.db");
        SQLiteUUIDService legacyUUIDService = Settings.UUID.LEGACY_DATABASE_SUPPORT && FileUtils.getFile((File)PlotSquared.platform().getDirectory(), (String)"usercache.db").exists() ? new SQLiteUUIDService("usercache.db") : null;
        if (Settings.UUID.SERVICE_LUCKPERMS && Bukkit.getPluginManager().getPlugin("LuckPerms") != null) {
            luckPermsUUIDService = new LuckPermsUUIDService();
            LOGGER.info("(UUID) Using LuckPerms as a complementary UUID service");
        } else {
            luckPermsUUIDService = null;
        }
        if (Settings.UUID.SERVICE_ESSENTIALSX && Bukkit.getPluginManager().getPlugin("Essentials") != null) {
            essentialsUUIDService = new EssentialsUUIDService();
            LOGGER.info("(UUID) Using EssentialsX as a complementary UUID service");
        } else {
            essentialsUUIDService = null;
        }
        if (!Settings.UUID.OFFLINE) {
            if (Bukkit.getOnlineMode() && PaperLib.isPaper() && Settings.UUID.SERVICE_PAPER) {
                PaperUUIDService paperUUIDService = new PaperUUIDService();
                this.impromptuPipeline.registerService((UUIDService)paperUUIDService);
                this.backgroundPipeline.registerService((UUIDService)paperUUIDService);
                LOGGER.info("(UUID) Using Paper as a complementary UUID service");
            }
            this.impromptuPipeline.registerService((UUIDService)sqLiteUUIDService);
            this.backgroundPipeline.registerService((UUIDService)sqLiteUUIDService);
            this.impromptuPipeline.registerConsumer((Consumer)sqLiteUUIDService);
            this.backgroundPipeline.registerConsumer((Consumer)sqLiteUUIDService);
            if (legacyUUIDService != null) {
                this.impromptuPipeline.registerService((UUIDService)legacyUUIDService);
                this.backgroundPipeline.registerService((UUIDService)legacyUUIDService);
            }
            if (luckPermsUUIDService != null) {
                this.impromptuPipeline.registerService((UUIDService)luckPermsUUIDService);
                this.backgroundPipeline.registerService((UUIDService)luckPermsUUIDService);
            }
            if (essentialsUUIDService != null) {
                this.impromptuPipeline.registerService((UUIDService)essentialsUUIDService);
                this.backgroundPipeline.registerService((UUIDService)essentialsUUIDService);
            }
            if (Settings.UUID.IMPROMPTU_SERVICE_MOJANG_API) {
                SquirrelIdUUIDService impromptuMojangService = new SquirrelIdUUIDService(Settings.UUID.IMPROMPTU_LIMIT);
                this.impromptuPipeline.registerService((UUIDService)impromptuMojangService);
            }
            SquirrelIdUUIDService backgroundMojangService = new SquirrelIdUUIDService(Settings.UUID.BACKGROUND_LIMIT);
            this.backgroundPipeline.registerService((UUIDService)backgroundMojangService);
        } else {
            this.impromptuPipeline.registerService((UUIDService)sqLiteUUIDService);
            this.backgroundPipeline.registerService((UUIDService)sqLiteUUIDService);
            this.impromptuPipeline.registerConsumer((Consumer)sqLiteUUIDService);
            this.backgroundPipeline.registerConsumer((Consumer)sqLiteUUIDService);
            if (legacyUUIDService != null) {
                this.impromptuPipeline.registerService((UUIDService)legacyUUIDService);
                this.backgroundPipeline.registerService((UUIDService)legacyUUIDService);
            }
        }
        this.impromptuPipeline.storeImmediately("*", DBFunc.EVERYONE);
        if (Settings.UUID.BACKGROUND_CACHING_ENABLED) {
            this.startUuidCaching(sqLiteUUIDService, cacheUUIDService);
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            ((PAPIPlaceholders)((Object)this.injector.getInstance(PAPIPlaceholders.class))).register();
            if (Settings.Enabled_Components.EXTERNAL_PLACEHOLDERS) {
                ChatFormatter.formatters.add((ChatFormatter)this.injector().getInstance(PlaceholderFormatter.class));
            }
            LOGGER.info("PlotSquared hooked into PlaceholderAPI");
        }
        this.startMetrics();
        if (Settings.Enabled_Components.WORLDS) {
            TaskManager.getPlatformImplementation().taskRepeat(this::unload, TaskTime.seconds((long)10L));
            try {
                this.singleWorldListener = (SingleWorldListener)this.injector().getInstance(SingleWorldListener.class);
                Bukkit.getPluginManager().registerEvents((Listener)this.singleWorldListener, (Plugin)this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            try {
                for (PlotPlayer player : this.playerManager().getPlayers()) {
                    if (player.getPlatformPlayer() != null && ((Player)player.getPlatformPlayer()).isOnline()) continue;
                    this.playerManager().removePlayer(player);
                }
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to clean up players: " + e.getMessage());
            }
        }, 100L, 100L);
        ServerLib.checkUnsafeForks();
    }

    private void unload() {
        if (!this.methodUnloadSetup) {
            this.methodUnloadSetup = true;
            try {
                ReflectionUtils.RefClass classCraftWorld = ReflectionUtils.getRefClass((String)"{cb}.CraftWorld");
                this.methodUnloadChunk0 = classCraftWorld.getRealClass().getDeclaredMethod("unloadChunk0", Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                this.methodUnloadChunk0.setAccessible(true);
            }
            catch (Throwable event) {
                event.printStackTrace();
            }
        }
        if (this.plotAreaManager instanceof SinglePlotAreaManager) {
            long start = System.currentTimeMillis();
            SinglePlotArea area = ((SinglePlotAreaManager)this.plotAreaManager).getArea();
            block6: for (org.bukkit.World world : Bukkit.getWorlds()) {
                PlotId id;
                String name = world.getName();
                char char0 = name.charAt(0);
                if (!Character.isDigit(char0) && char0 != '-' || !world.getPlayers().isEmpty()) continue;
                try {
                    id = PlotId.fromString((String)name);
                }
                catch (IllegalArgumentException ignored) {
                    continue;
                }
                Plot plot = area.getOwnedPlot(id);
                if (plot == null || ((Boolean)plot.getFlag(ServerPlotFlag.class)).booleanValue() && PlotSquared.platform().playerManager().getPlayerIfExists(plot.getOwner()) != null) continue;
                if (world.getKeepSpawnInMemory()) {
                    world.setKeepSpawnInMemory(false);
                    return;
                }
                Chunk[] chunks = world.getLoadedChunks();
                if (chunks.length == 0) {
                    if (!Bukkit.unloadWorld((org.bukkit.World)world, (boolean)true)) {
                        LOGGER.warn("Failed to unload {}", (Object)world.getName());
                    }
                    return;
                }
                int index = 0;
                do {
                    boolean result;
                    block14: {
                        Chunk chunkI = chunks[index++];
                        if (this.methodUnloadChunk0 != null) {
                            try {
                                result = (Boolean)this.methodUnloadChunk0.invoke((Object)world, chunkI.getX(), chunkI.getZ(), true);
                                break block14;
                            }
                            catch (Throwable e) {
                                this.methodUnloadChunk0 = null;
                                e.printStackTrace();
                                continue block6;
                            }
                        }
                        result = world.unloadChunk(chunkI.getX(), chunkI.getZ(), true);
                    }
                    if (!result) continue block6;
                    if (System.currentTimeMillis() - start <= 5L) continue;
                    return;
                } while (index < chunks.length);
            }
        }
    }

    private void startUuidCaching(@NonNull SQLiteUUIDService sqLiteUUIDService, @NonNull CacheUUIDService cacheUUIDService) {
        HashSet uuidSet = new HashSet();
        PlotSquared.get().forEachPlotRaw(plot -> {
            uuidSet.add(plot.getOwnerAbs());
            uuidSet.addAll(plot.getMembers());
            uuidSet.addAll(plot.getTrusted());
            uuidSet.addAll(plot.getDenied());
        });
        LinkedBlockingQueue uuidQueue = new LinkedBlockingQueue(uuidSet);
        LOGGER.info("(UUID) {} UUIDs will be cached", (Object)uuidQueue.size());
        Executors.newSingleThreadScheduledExecutor().schedule(() -> {
            cacheUUIDService.accept(sqLiteUUIDService.getAll());
            int totalSize = uuidQueue.size();
            int read = 0;
            LOGGER.info("(UUID) PlotSquared will fetch UUIDs in groups of {}", (Object)Settings.UUID.BACKGROUND_LIMIT);
            ArrayList<UUID> uuidList = new ArrayList<UUID>(Settings.UUID.BACKGROUND_LIMIT);
            boolean secondRun = false;
            while (!uuidQueue.isEmpty() || !uuidList.isEmpty()) {
                if (!uuidList.isEmpty() && secondRun) {
                    LOGGER.warn("(UUID) Giving up on last batch. Fetching new batch instead");
                    uuidList.clear();
                }
                if (uuidList.isEmpty()) {
                    secondRun = false;
                    for (int i = 0; i < Settings.UUID.BACKGROUND_LIMIT && !uuidQueue.isEmpty(); ++i) {
                        uuidList.add((UUID)uuidQueue.poll());
                        ++read;
                    }
                } else {
                    secondRun = true;
                }
                try {
                    PlotSquared.get().getBackgroundUUIDPipeline().getNames(uuidList).get();
                    uuidList.clear();
                    double percentage = (double)read / (double)totalSize * 100.0;
                    if (!Settings.DEBUG) continue;
                    LOGGER.info("(UUID) PlotSquared has cached {} of UUIDs", (Object)String.format("%.1f%%", percentage));
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.error("(UUID) Failed to retrieve last batch. Will try again", (Throwable)e);
                }
            }
            LOGGER.info("(UUID) PlotSquared has cached all UUIDs");
        }, 10L, TimeUnit.SECONDS);
    }

    public void onDisable() {
        PlotSquared.get().disable();
        Bukkit.getScheduler().cancelTasks((Plugin)this);
    }

    public void shutdown() {
        this.getServer().getPluginManager().disablePlugin((Plugin)this);
    }

    public void shutdownServer() {
        this.getServer().shutdown();
    }

    private void registerCommands() {
        BukkitCommand bukkitCommand = new BukkitCommand();
        PluginCommand plotCommand = this.getCommand("plots");
        if (plotCommand != null) {
            plotCommand.setExecutor((CommandExecutor)bukkitCommand);
            plotCommand.setAliases(Arrays.asList("p", "ps", "plotme", "plot"));
            plotCommand.setTabCompleter((TabCompleter)bukkitCommand);
        }
    }

    public @NonNull File getDirectory() {
        return this.getDataFolder();
    }

    public @NonNull File worldContainer() {
        return Bukkit.getWorldContainer();
    }

    private void runEntityTask() {
        TaskManager.runTaskRepeat(() -> this.plotAreaManager.forEachPlotArea(plotArea -> {
            org.bukkit.World world = Bukkit.getWorld((String)plotArea.getWorldName());
            try {
                if (world == null) {
                    return;
                }
                List entities = world.getEntities();
                Iterator<Entity> iterator = entities.iterator();
                block122: while (iterator.hasNext()) {
                    Entity passenger;
                    org.bukkit.Location location;
                    Entity entity = (Entity)iterator.next();
                    switch (entity.getType().toString()) {
                        case "EGG": 
                        case "FISHING_HOOK": 
                        case "ENDER_SIGNAL": 
                        case "AREA_EFFECT_CLOUD": 
                        case "EXPERIENCE_ORB": 
                        case "LEASH_HITCH": 
                        case "FIREWORK": 
                        case "LIGHTNING": 
                        case "WITHER_SKULL": 
                        case "UNKNOWN": 
                        case "PLAYER": {
                            continue block122;
                        }
                        case "THROWN_EXP_BOTTLE": 
                        case "SPLASH_POTION": 
                        case "SNOWBALL": 
                        case "SHULKER_BULLET": 
                        case "SPECTRAL_ARROW": 
                        case "ENDER_PEARL": 
                        case "ARROW": 
                        case "LLAMA_SPIT": 
                        case "TRIDENT": {
                            continue block122;
                        }
                        case "ITEM_FRAME": 
                        case "PAINTING": {
                            continue block122;
                        }
                        case "ARMOR_STAND": 
                        case "MINECART": 
                        case "MINECART_CHEST": 
                        case "MINECART_COMMAND": 
                        case "MINECART_FURNACE": 
                        case "MINECART_HOPPER": 
                        case "MINECART_MOB_SPAWNER": 
                        case "ENDER_CRYSTAL": 
                        case "MINECART_TNT": 
                        case "BOAT": {
                            Plot origin;
                            if (!Settings.Enabled_Components.KILL_ROAD_VEHICLES) continue block122;
                            location = BukkitUtil.adapt(entity.getLocation());
                            Plot plot = location.getPlot();
                            if (plot == null) {
                                if (!location.isPlotArea() || entity.hasMetadata("ps-tmp-teleport")) continue block122;
                                this.removeRoadEntity(entity, iterator);
                                continue block122;
                            }
                            List meta = entity.getMetadata("plot");
                            if (meta.isEmpty() || plot.equals((Object)(origin = (Plot)((MetadataValue)meta.get(0)).value()).getBasePlot(false)) || entity.hasMetadata("ps-tmp-teleport")) continue block122;
                            this.removeRoadEntity(entity, iterator);
                            continue block122;
                        }
                        case "SMALL_FIREBALL": 
                        case "FIREBALL": 
                        case "DRAGON_FIREBALL": 
                        case "DROPPED_ITEM": {
                            if (!Settings.Enabled_Components.KILL_ROAD_ITEMS || plotArea.getOwnedPlotAbs(BukkitUtil.adapt(entity.getLocation())) != null) continue block122;
                            this.removeRoadEntity(entity, iterator);
                            continue block122;
                        }
                        case "PRIMED_TNT": 
                        case "FALLING_BLOCK": {
                            continue block122;
                        }
                        case "SHULKER": {
                            Plot currentPlot;
                            if (!Settings.Enabled_Components.KILL_ROAD_MOBS || !Settings.Enabled_Components.KILL_NAMED_ROAD_MOBS && entity.getCustomName() != null) continue block122;
                            LivingEntity livingEntity = (LivingEntity)entity;
                            List meta = entity.getMetadata("shulkerPlot");
                            if (!meta.isEmpty()) {
                                Plot currentPlot2;
                                Location pLoc;
                                PlotArea area;
                                PlotId originalPlotId;
                                List keep;
                                if (livingEntity.isLeashed() && !Settings.Enabled_Components.KILL_OWNED_ROAD_MOBS || !(keep = entity.getMetadata("keep")).isEmpty() || (originalPlotId = (PlotId)((MetadataValue)meta.get(0)).value()) == null || (area = (pLoc = BukkitUtil.adapt(entity.getLocation())).getPlotArea()) == null || (currentPlot2 = area.getPlotAbs(pLoc)) != null && originalPlotId.equals((Object)currentPlot2.getId()) || entity.hasMetadata("ps-tmp-teleport")) continue block122;
                                this.removeRoadEntity(entity, iterator);
                                continue block122;
                            }
                            Location pLoc = BukkitUtil.adapt(entity.getLocation());
                            PlotArea area = pLoc.getPlotArea();
                            if (area == null || (currentPlot = area.getPlotAbs(pLoc)) == null) continue block122;
                            entity.setMetadata("shulkerPlot", (MetadataValue)new FixedMetadataValue((Plugin)PlotSquared.platform(), (Object)currentPlot.getId()));
                            continue block122;
                        }
                    }
                    if (!Settings.Enabled_Components.KILL_ROAD_MOBS || !BukkitUtil.adapt(location = entity.getLocation()).isPlotRoad()) continue;
                    if (entity instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity;
                        if (!Settings.Enabled_Components.KILL_OWNED_ROAD_MOBS && livingEntity.isLeashed() && entity.hasMetadata("keep")) continue;
                        passenger = entity.getPassenger();
                        if (!Settings.Enabled_Components.KILL_OWNED_ROAD_MOBS && (passenger instanceof Player || livingEntity.isLeashed()) || !Settings.Enabled_Components.KILL_NAMED_ROAD_MOBS && entity.getCustomName() != null || !entity.getMetadata("keep").isEmpty() || entity.hasMetadata("ps-tmp-teleport")) continue;
                        this.removeRoadEntity(entity, iterator);
                        continue;
                    }
                    passenger = entity.getPassenger();
                    if (!Settings.Enabled_Components.KILL_OWNED_ROAD_MOBS && passenger instanceof Player || !Settings.Enabled_Components.KILL_NAMED_ROAD_MOBS || entity.getCustomName() == null || !entity.getMetadata("keep").isEmpty() || entity.hasMetadata("ps-tmp-teleport")) continue;
                    this.removeRoadEntity(entity, iterator);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }), (TaskTime)TaskTime.seconds((long)1L));
    }

    private void removeRoadEntity(Entity entity, Iterator<Entity> entityIterator) {
        RemoveRoadEntityEvent event = this.eventDispatcher.callRemoveRoadEntity(BukkitAdapter.adapt((Entity)entity));
        if (event.getEventResult() == Result.DENY) {
            return;
        }
        entityIterator.remove();
        entity.remove();
    }

    public final @Nullable ChunkGenerator getDefaultWorldGenerator(@NonNull String worldName, @Nullable String id) {
        IndependentPlotGenerator result;
        if (id != null && id.equalsIgnoreCase("single")) {
            result = (IndependentPlotGenerator)this.injector().getInstance(SingleWorldGenerator.class);
        } else {
            result = (IndependentPlotGenerator)this.injector().getInstance(Key.get(IndependentPlotGenerator.class, DefaultGenerator.class));
            if (!PlotSquared.get().setupPlotWorld(worldName, id, result)) {
                return null;
            }
        }
        return (ChunkGenerator)result.specify(worldName);
    }

    public @Nullable GeneratorWrapper<?> getGenerator(@NonNull String world, @Nullable String name) {
        if (name == null) {
            return null;
        }
        Plugin genPlugin = Bukkit.getPluginManager().getPlugin(name);
        if (genPlugin != null && genPlugin.isEnabled()) {
            ChunkGenerator gen = genPlugin.getDefaultWorldGenerator(world, "");
            if (gen instanceof GeneratorWrapper) {
                return (GeneratorWrapper)gen;
            }
            return new BukkitPlotGenerator(world, gen, this.plotAreaManager);
        }
        return new BukkitPlotGenerator(world, (IndependentPlotGenerator)this.injector().getInstance(Key.get(IndependentPlotGenerator.class, DefaultGenerator.class)), this.plotAreaManager);
    }

    public void startMetrics() {
        if (this.metricsStarted) {
            return;
        }
        this.metricsStarted = true;
        Metrics metrics = new Metrics((JavaPlugin)this, 1404);
        metrics.addCustomChart((CustomChart)new DrilldownPie("area_types", () -> {
            HashMap map = new HashMap();
            for (PlotAreaType plotAreaType : PlotAreaType.values()) {
                HashMap<String, Integer> terrainTypes = new HashMap<String, Integer>();
                for (PlotAreaTerrainType plotAreaTerrainType : PlotAreaTerrainType.values()) {
                    terrainTypes.put(plotAreaTerrainType.name().toLowerCase(), 0);
                }
                map.put(plotAreaType.name().toLowerCase(), terrainTypes);
            }
            for (PlotAreaType plotAreaType : this.plotAreaManager.getAllPlotAreas()) {
                Map terrainTypeMap = (Map)map.get(plotAreaType.getType().name().toLowerCase());
                terrainTypeMap.put(plotAreaType.getTerrain().name().toLowerCase(), (Integer)terrainTypeMap.get(plotAreaType.getTerrain().name().toLowerCase()) + 1);
            }
            return map;
        }));
        metrics.addCustomChart((CustomChart)new SimplePie("premium", () -> PremiumVerification.isPremium() != false ? "Premium" : "Non-Premium"));
        metrics.addCustomChart((CustomChart)new SimplePie("worlds", () -> Settings.Enabled_Components.WORLDS ? "true" : "false"));
        metrics.addCustomChart((CustomChart)new SimplePie("economy", () -> Settings.Enabled_Components.ECONOMY ? "true" : "false"));
        metrics.addCustomChart((CustomChart)new SimplePie("plot_expiry", () -> Settings.Enabled_Components.PLOT_EXPIRY ? "true" : "false"));
        metrics.addCustomChart((CustomChart)new SimplePie("database_type", () -> Storage.MySQL.USE ? "MySQL" : "SQLite"));
        metrics.addCustomChart((CustomChart)new SimplePie("worldedit_implementation", () -> Bukkit.getPluginManager().getPlugin("FastAsyncWorldEdit") != null ? "FastAsyncWorldEdit" : "WorldEdit"));
        metrics.addCustomChart((CustomChart)new SimplePie("offline_mode", () -> Settings.UUID.OFFLINE ? "true" : "false"));
        metrics.addCustomChart((CustomChart)new SimplePie("offline_mode_force", () -> Settings.UUID.FORCE_LOWERCASE ? "true" : "false"));
    }

    public void unregister(@NonNull PlotPlayer<?> player) {
        PlotSquared.platform().playerManager().removePlayer(player.getUUID());
    }

    public void setGenerator(@NonNull String worldName) {
        org.bukkit.World world = BukkitUtil.getWorld(worldName);
        if (world == null) {
            ConfigurationSection worldConfig = this.worldConfiguration.getConfigurationSection("worlds." + worldName);
            String manager = worldConfig.getString("generator.plugin", this.pluginName());
            PlotAreaBuilder builder = PlotAreaBuilder.newBuilder().plotManager(manager).generatorName(worldConfig.getString("generator.init", manager)).plotAreaType(ConfigurationUtil.getType((ConfigurationSection)worldConfig)).terrainType(ConfigurationUtil.getTerrain((ConfigurationSection)worldConfig)).settingsNodesWrapper(new SettingsNodesWrapper(new ConfigurationNode[0], null)).worldName(worldName);
            ((SetupUtils)this.injector().getInstance(SetupUtils.class)).setupWorld(builder);
            world = Bukkit.getWorld((String)worldName);
        } else {
            try {
                if (!this.plotAreaManager.hasPlotArea(worldName)) {
                    SetGenCB.setGenerator(BukkitUtil.getWorld(worldName));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to reload world: {} | {}", (Object)world, (Object)e.getMessage());
                Bukkit.getServer().unloadWorld(world, false);
                return;
            }
        }
        assert (world != null);
        ChunkGenerator gen = world.getGenerator();
        if (gen instanceof BukkitPlotGenerator) {
            PlotSquared.get().loadWorld(worldName, (GeneratorWrapper)((BukkitPlotGenerator)gen));
        } else if (gen != null) {
            PlotSquared.get().loadWorld(worldName, (GeneratorWrapper)new BukkitPlotGenerator(worldName, gen, this.plotAreaManager));
        } else if (this.worldConfiguration.contains("worlds." + worldName)) {
            PlotSquared.get().loadWorld(worldName, null);
        }
    }

    public @NonNull String serverNativePackage() {
        String name = Bukkit.getServer().getClass().getPackage().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public @NonNull GeneratorWrapper<?> wrapPlotGenerator(@NonNull String world, @NonNull IndependentPlotGenerator generator) {
        return new BukkitPlotGenerator(world, generator, this.plotAreaManager);
    }

    public @NonNull String pluginsFormatted() {
        StringBuilder msg = new StringBuilder();
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        Collections.addAll(plugins, Bukkit.getServer().getPluginManager().getPlugins());
        plugins.sort(Comparator.comparing(Plugin::getName));
        msg.append("Plugins (").append(plugins.size()).append("): \n");
        for (Plugin p : plugins) {
            msg.append(" - ").append(p.getName()).append(":").append("\n").append("  \u2022 Version: ").append(p.getDescription().getVersion()).append("\n").append("  \u2022 Enabled: ").append(p.isEnabled()).append("\n").append("  \u2022 Main: ").append(p.getDescription().getMain()).append("\n").append("  \u2022 Authors: ").append(p.getDescription().getAuthors()).append("\n").append("  \u2022 Load Before: ").append(p.getDescription().getLoadBefore()).append("\n").append("  \u2022 Dependencies: ").append(p.getDescription().getDepend()).append("\n").append("  \u2022 Soft Dependencies: ").append(p.getDescription().getSoftDepend()).append("\n");
            List providers = Bukkit.getServicesManager().getRegistrations(p);
            if (providers.isEmpty()) continue;
            msg.append("  \u2022 Provided Services: \n");
            for (RegisteredServiceProvider provider : providers) {
                msg.append("    \u2022 ").append(provider.getService().getName()).append(" = ").append(provider.getProvider().getClass().getName()).append(" (priority: ").append(provider.getPriority()).append(")").append("\n");
            }
        }
        return msg.toString();
    }

    public @NonNull String worldEditImplementations() {
        StringBuilder msg = new StringBuilder();
        if (Bukkit.getPluginManager().getPlugin("FastAsyncWorldEdit") != null) {
            msg.append("FastAsyncWorldEdit: ").append(Bukkit.getPluginManager().getPlugin("FastAsyncWorldEdit").getDescription().getVersion());
        } else if (Bukkit.getPluginManager().getPlugin("AsyncWorldEdit") != null) {
            msg.append("AsyncWorldEdit: ").append(Bukkit.getPluginManager().getPlugin("AsyncWorldEdit").getDescription().getVersion()).append("\n");
            msg.append("WorldEdit: ").append(Bukkit.getPluginManager().getPlugin("WorldEdit").getDescription().getVersion());
        } else {
            msg.append("WorldEdit: ").append(Bukkit.getPluginManager().getPlugin("WorldEdit").getDescription().getVersion());
        }
        return msg.toString();
    }

    public @NonNull World<?> getPlatformWorld(@NonNull String worldName) {
        return BukkitWorld.of(worldName);
    }

    public @NonNull Audience consoleAudience() {
        return BukkitUtil.BUKKIT_AUDIENCES.console();
    }

    public @NonNull String pluginName() {
        return this.pluginName;
    }

    public SingleWorldListener getSingleWorldListener() {
        return this.singleWorldListener;
    }

    public @NonNull Injector injector() {
        return this.injector;
    }

    public @NonNull PlotAreaManager plotAreaManager() {
        return this.plotAreaManager;
    }

    public @NonNull Locale getLocale() {
        return this.serverLocale;
    }

    public void setLocale(@NonNull Locale locale) {
        throw new UnsupportedOperationException("Cannot replace server locale");
    }

    public @NonNull PlatformWorldManager<?> worldManager() {
        return (PlatformWorldManager)this.injector().getInstance(Key.get((TypeLiteral)new TypeLiteral<PlatformWorldManager<org.bukkit.World>>(){}));
    }

    public @NonNull PlayerManager<? extends PlotPlayer<Player>, ? extends Player> playerManager() {
        return (PlayerManager)this.injector().getInstance(PlayerManager.class);
    }

    public void copyCaptionMaps() {
        String[] languages;
        for (String language : languages = new String[]{"en"}) {
            if (new File(new File(this.getDataFolder(), "lang"), String.format("messages_%s.json", language)).exists()) continue;
            this.saveResource(String.format("lang/messages_%s.json", language), false);
            LOGGER.info("Copied language file 'messages_{}.json'", (Object)language);
        }
    }

    public @NonNull String toLegacyPlatformString(@NonNull Component component) {
        return LegacyComponentSerializer.legacyAmpersand().serialize(component);
    }

    public boolean isFaweHooking() {
        return this.faweHook;
    }

    static {
        try {
            Settings.load((File)new File(PlotSquared.platform().getDirectory(), "settings.yml"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

