/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.util;

import com.google.common.collect.Maps;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BukkitWorld
implements com.plotsquared.core.location.World<World> {
    private static final Map<String, BukkitWorld> worldMap;
    private static final boolean HAS_MIN_Y;
    private final World world;

    private BukkitWorld(World world) {
        this.world = world;
    }

    public static @NonNull BukkitWorld of(@NonNull String worldName) {
        World bukkitWorld = Bukkit.getWorld((String)worldName);
        if (bukkitWorld == null) {
            throw new IllegalArgumentException(String.format("There is no world with the name '%s'", worldName));
        }
        return BukkitWorld.of(bukkitWorld);
    }

    public static @NonNull BukkitWorld of(World world) {
        BukkitWorld bukkitWorld = worldMap.get(world.getName());
        if (bukkitWorld != null && bukkitWorld.getPlatformWorld().equals(world)) {
            return bukkitWorld;
        }
        bukkitWorld = new BukkitWorld(world);
        worldMap.put(world.getName(), bukkitWorld);
        return bukkitWorld;
    }

    public static int getMinWorldHeight(World world) {
        return HAS_MIN_Y ? world.getMinHeight() : 0;
    }

    public static int getMaxWorldHeight(World world) {
        return HAS_MIN_Y ? world.getMaxHeight() : 256;
    }

    public World getPlatformWorld() {
        return this.world;
    }

    public @NonNull String getName() {
        return this.world.getName();
    }

    public int getMinHeight() {
        return BukkitWorld.getMinWorldHeight(this.world);
    }

    public int getMaxHeight() {
        return BukkitWorld.getMaxWorldHeight(this.world) - 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BukkitWorld that = (BukkitWorld)o;
        return this.world.equals(that.world);
    }

    public int hashCode() {
        return this.world.hashCode();
    }

    public String toString() {
        return "BukkitWorld(world=" + this.world + ")";
    }

    static {
        boolean temp;
        worldMap = Maps.newHashMap();
        try {
            World.class.getMethod("getMinHeight", new Class[0]);
            temp = true;
        }
        catch (NoSuchMethodException e) {
            temp = false;
        }
        HAS_MIN_Y = temp;
    }
}

