/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.player;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.plotsquared.bukkit.player.BukkitOfflinePlayer;
import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.core.permissions.PermissionHandler;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.PlayerManager;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Singleton
public class BukkitPlayerManager
extends PlayerManager<BukkitPlayer, Player> {
    private final PlotAreaManager plotAreaManager;
    private final EventDispatcher eventDispatcher;
    private final PermissionHandler permissionHandler;

    @Inject
    public BukkitPlayerManager(@NonNull PlotAreaManager plotAreaManager, @NonNull EventDispatcher eventDispatcher, @NonNull PermissionHandler permissionHandler) {
        this.plotAreaManager = plotAreaManager;
        this.eventDispatcher = eventDispatcher;
        this.permissionHandler = permissionHandler;
    }

    public @NonNull BukkitPlayer getPlayer(@NonNull Player object) {
        if (object.getUniqueId().version() == 2) {
            return new BukkitPlayer(this.plotAreaManager, this.eventDispatcher, object, false, this.permissionHandler);
        }
        if (!object.isOnline()) {
            throw new PlayerManager.NoSuchPlayerException(object.getUniqueId());
        }
        return (BukkitPlayer)this.getPlayer(object.getUniqueId());
    }

    public @NonNull BukkitPlayer createPlayer(@NonNull UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null || !player.isOnline()) {
            throw new PlayerManager.NoSuchPlayerException(uuid);
        }
        return new BukkitPlayer(this.plotAreaManager, this.eventDispatcher, player, false, this.permissionHandler);
    }

    public @Nullable BukkitOfflinePlayer getOfflinePlayer(@Nullable UUID uuid) {
        if (uuid == null) {
            return null;
        }
        return new BukkitOfflinePlayer(Bukkit.getOfflinePlayer((UUID)uuid), this.permissionHandler);
    }

    public @NonNull BukkitOfflinePlayer getOfflinePlayer(@NonNull String username) {
        return new BukkitOfflinePlayer(Bukkit.getOfflinePlayer((String)username), this.permissionHandler);
    }
}

