/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.service;

import com.influxdb.client.domain.AddResourceMemberRequestBody;
import com.influxdb.client.domain.LabelMapping;
import com.influxdb.client.domain.LabelResponse;
import com.influxdb.client.domain.LabelsResponse;
import com.influxdb.client.domain.ResourceMember;
import com.influxdb.client.domain.ResourceMembers;
import com.influxdb.client.domain.ResourceOwner;
import com.influxdb.client.domain.ResourceOwners;
import com.influxdb.client.domain.Telegraf;
import com.influxdb.client.domain.TelegrafPluginRequest;
import com.influxdb.client.domain.Telegrafs;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface TelegrafsService {
    @DELETE(value="api/v2/telegrafs/{telegrafID}")
    public Call<Void> deleteTelegrafsID(@Path(value="telegrafID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @DELETE(value="api/v2/telegrafs/{telegrafID}/labels/{labelID}")
    public Call<Void> deleteTelegrafsIDLabelsID(@Path(value="telegrafID") String var1, @Path(value="labelID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/telegrafs/{telegrafID}/members/{userID}")
    public Call<Void> deleteTelegrafsIDMembersID(@Path(value="userID") String var1, @Path(value="telegrafID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/telegrafs/{telegrafID}/owners/{userID}")
    public Call<Void> deleteTelegrafsIDOwnersID(@Path(value="userID") String var1, @Path(value="telegrafID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @GET(value="api/v2/telegrafs")
    public Call<Telegrafs> getTelegrafs(@Header(value="Zap-Trace-Span") String var1, @Query(value="orgID") String var2);

    @GET(value="api/v2/telegrafs/{telegrafID}")
    public Call<String> getTelegrafsID(@Path(value="telegrafID") String var1, @Header(value="Zap-Trace-Span") String var2, @Header(value="Accept") String var3);

    @GET(value="api/v2/telegrafs/{telegrafID}")
    public Call<ResponseBody> getTelegrafsIDResponseBody(@Path(value="telegrafID") String var1, @Header(value="Zap-Trace-Span") String var2, @Header(value="Accept") String var3);

    @GET(value="api/v2/telegrafs/{telegrafID}")
    public Call<String> getTelegrafsIDString(@Path(value="telegrafID") String var1, @Header(value="Zap-Trace-Span") String var2, @Header(value="Accept") String var3);

    @GET(value="api/v2/telegrafs/{telegrafID}")
    public Call<Telegraf> getTelegrafsIDTelegraf(@Path(value="telegrafID") String var1, @Header(value="Zap-Trace-Span") String var2, @Header(value="Accept") String var3);

    @GET(value="api/v2/telegrafs/{telegrafID}/labels")
    public Call<LabelsResponse> getTelegrafsIDLabels(@Path(value="telegrafID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/telegrafs/{telegrafID}/members")
    public Call<ResourceMembers> getTelegrafsIDMembers(@Path(value="telegrafID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/telegrafs/{telegrafID}/owners")
    public Call<ResourceOwners> getTelegrafsIDOwners(@Path(value="telegrafID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/telegrafs")
    public Call<Telegraf> postTelegrafs(@Body TelegrafPluginRequest var1, @Header(value="Zap-Trace-Span") String var2);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/telegrafs/{telegrafID}/labels")
    public Call<LabelResponse> postTelegrafsIDLabels(@Path(value="telegrafID") String var1, @Body LabelMapping var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/telegrafs/{telegrafID}/members")
    public Call<ResourceMember> postTelegrafsIDMembers(@Path(value="telegrafID") String var1, @Body AddResourceMemberRequestBody var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/telegrafs/{telegrafID}/owners")
    public Call<ResourceOwner> postTelegrafsIDOwners(@Path(value="telegrafID") String var1, @Body AddResourceMemberRequestBody var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @PUT(value="api/v2/telegrafs/{telegrafID}")
    public Call<Telegraf> putTelegrafsID(@Path(value="telegrafID") String var1, @Body TelegrafPluginRequest var2, @Header(value="Zap-Trace-Span") String var3);
}

