/*
 * InfluxDB OSS API Service
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint. 
 *
 * OpenAPI spec version: 2.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.influxdb.client.domain;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.CheckBase;
import com.influxdb.client.domain.CheckBaseLinks;
import com.influxdb.client.domain.DashboardQuery;
import com.influxdb.client.domain.Label;
import com.influxdb.client.domain.TaskStatusType;
import com.influxdb.client.domain.Threshold;
import com.influxdb.client.domain.ThresholdCheckTags;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * ThresholdCheck
 */

public class ThresholdCheck extends Check {
  /**
   * Gets or Sets type
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    THRESHOLD("threshold");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String text) {
      for (TypeEnum b : TypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return TypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type = TypeEnum.THRESHOLD;

  public static final String SERIALIZED_NAME_THRESHOLDS = "thresholds";
  @SerializedName(SERIALIZED_NAME_THRESHOLDS)
  private List<Threshold> thresholds = new ArrayList<>();

  public static final String SERIALIZED_NAME_EVERY = "every";
  @SerializedName(SERIALIZED_NAME_EVERY)
  private String every;

  public static final String SERIALIZED_NAME_OFFSET = "offset";
  @SerializedName(SERIALIZED_NAME_OFFSET)
  private String offset;

  public static final String SERIALIZED_NAME_TAGS = "tags";
  @SerializedName(SERIALIZED_NAME_TAGS)
  private List<ThresholdCheckTags> tags = new ArrayList<>();

  public static final String SERIALIZED_NAME_STATUS_MESSAGE_TEMPLATE = "statusMessageTemplate";
  @SerializedName(SERIALIZED_NAME_STATUS_MESSAGE_TEMPLATE)
  private String statusMessageTemplate;

   /**
   * Get type
   * @return type
  **/
  public TypeEnum getType() {
    return type;
  }

  public ThresholdCheck thresholds(List<Threshold> thresholds) {
    this.thresholds = thresholds;
    return this;
  }

  public ThresholdCheck addThresholdsItem(Threshold thresholdsItem) {
    if (this.thresholds == null) {
      this.thresholds = new ArrayList<>();
    }
    this.thresholds.add(thresholdsItem);
    return this;
  }

   /**
   * Get thresholds
   * @return thresholds
  **/
  public List<Threshold> getThresholds() {
    return thresholds;
  }

  public void setThresholds(List<Threshold> thresholds) {
    this.thresholds = thresholds;
  }

  public ThresholdCheck every(String every) {
    this.every = every;
    return this;
  }

   /**
   * Check repetition interval.
   * @return every
  **/
  public String getEvery() {
    return every;
  }

  public void setEvery(String every) {
    this.every = every;
  }

  public ThresholdCheck offset(String offset) {
    this.offset = offset;
    return this;
  }

   /**
   * Duration to delay after the schedule, before executing check.
   * @return offset
  **/
  public String getOffset() {
    return offset;
  }

  public void setOffset(String offset) {
    this.offset = offset;
  }

  public ThresholdCheck tags(List<ThresholdCheckTags> tags) {
    this.tags = tags;
    return this;
  }

  public ThresholdCheck addTagsItem(ThresholdCheckTags tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * List of tags to write to each status.
   * @return tags
  **/
  public List<ThresholdCheckTags> getTags() {
    return tags;
  }

  public void setTags(List<ThresholdCheckTags> tags) {
    this.tags = tags;
  }

  public ThresholdCheck statusMessageTemplate(String statusMessageTemplate) {
    this.statusMessageTemplate = statusMessageTemplate;
    return this;
  }

   /**
   * The template used to generate and write a status message.
   * @return statusMessageTemplate
  **/
  public String getStatusMessageTemplate() {
    return statusMessageTemplate;
  }

  public void setStatusMessageTemplate(String statusMessageTemplate) {
    this.statusMessageTemplate = statusMessageTemplate;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ThresholdCheck thresholdCheck = (ThresholdCheck) o;
    return Objects.equals(this.type, thresholdCheck.type) &&
        Objects.equals(this.thresholds, thresholdCheck.thresholds) &&
        Objects.equals(this.every, thresholdCheck.every) &&
        Objects.equals(this.offset, thresholdCheck.offset) &&
        Objects.equals(this.tags, thresholdCheck.tags) &&
        Objects.equals(this.statusMessageTemplate, thresholdCheck.statusMessageTemplate) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, thresholds, every, offset, tags, statusMessageTemplate, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ThresholdCheck {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    thresholds: ").append(toIndentedString(thresholds)).append("\n");
    sb.append("    every: ").append(toIndentedString(every)).append("\n");
    sb.append("    offset: ").append(toIndentedString(offset)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    statusMessageTemplate: ").append(toIndentedString(statusMessageTemplate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

