/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.Arguments;
import com.influxdb.client.OrganizationsApi;
import com.influxdb.client.domain.AddResourceMemberRequestBody;
import com.influxdb.client.domain.Organization;
import com.influxdb.client.domain.Organizations;
import com.influxdb.client.domain.PatchOrganizationRequest;
import com.influxdb.client.domain.PostOrganizationRequest;
import com.influxdb.client.domain.ResourceMember;
import com.influxdb.client.domain.ResourceMembers;
import com.influxdb.client.domain.ResourceOwner;
import com.influxdb.client.domain.ResourceOwners;
import com.influxdb.client.domain.SecretKeys;
import com.influxdb.client.domain.SecretKeysResponse;
import com.influxdb.client.domain.User;
import com.influxdb.client.service.OrganizationsService;
import com.influxdb.client.service.SecretsService;
import com.influxdb.internal.AbstractRestClient;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import retrofit2.Call;

final class OrganizationsApiImpl
extends AbstractRestClient
implements OrganizationsApi {
    private static final Logger LOG = Logger.getLogger(OrganizationsApiImpl.class.getName());
    private final OrganizationsService service;
    private final SecretsService secretsService;

    OrganizationsApiImpl(@Nonnull OrganizationsService service, @Nonnull SecretsService secretsService) {
        Arguments.checkNotNull((Object)service, (String)"service");
        Arguments.checkNotNull((Object)secretsService, (String)"secretsService");
        this.service = service;
        this.secretsService = secretsService;
    }

    @Override
    @Nonnull
    public Organization findOrganizationByID(@Nonnull String orgID) {
        Arguments.checkNonEmpty((String)orgID, (String)"Organization ID");
        Call<Organization> organization = this.service.getOrgsID(orgID, null);
        return (Organization)this.execute(organization);
    }

    @Override
    @Nonnull
    public List<Organization> findOrganizations() {
        Call<Organizations> organizationsCall = this.service.getOrgs(null, null, null, null, null, null, null);
        Organizations organizations = (Organizations)this.execute(organizationsCall);
        LOG.log(Level.FINEST, "findOrganizations found: {0}", organizations);
        return organizations.getOrgs();
    }

    @Override
    @Nonnull
    public Organization createOrganization(@Nonnull String name) {
        Arguments.checkNonEmpty((String)name, (String)"Organization name");
        Organization organization = new Organization();
        organization.setName(name);
        return this.createOrganization(organization);
    }

    @Override
    @Nonnull
    public Organization createOrganization(@Nonnull Organization organization) {
        Arguments.checkNotNull((Object)organization, (String)"Organization");
        PostOrganizationRequest request = new PostOrganizationRequest().name(organization.getName()).description(organization.getDescription());
        Call<Organization> call = this.service.postOrgs(request, null);
        return (Organization)this.execute(call);
    }

    @Override
    @Nonnull
    public Organization updateOrganization(@Nonnull Organization organization) {
        Arguments.checkNotNull((Object)organization, (String)"Organization");
        PatchOrganizationRequest patch = new PatchOrganizationRequest().name(organization.getName()).description(organization.getName());
        Call<Organization> orgCall = this.service.patchOrgsID(organization.getId(), patch, null);
        return (Organization)this.execute(orgCall);
    }

    @Override
    public void deleteOrganization(@Nonnull Organization organization) {
        Arguments.checkNotNull((Object)organization, (String)"Organization is required");
        this.deleteOrganization(organization.getId());
    }

    @Override
    public void deleteOrganization(@Nonnull String orgID) {
        Arguments.checkNonEmpty((String)orgID, (String)"Organization ID");
        Call<Void> call = this.service.deleteOrgsID(orgID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public Organization cloneOrganization(@Nonnull String clonedName, @Nonnull String orgID) {
        Arguments.checkNonEmpty((String)clonedName, (String)"clonedName");
        Arguments.checkNonEmpty((String)orgID, (String)"orgID");
        Organization organization = this.findOrganizationByID(orgID);
        return this.cloneOrganization(clonedName, organization);
    }

    @Override
    @Nonnull
    public Organization cloneOrganization(@Nonnull String clonedName, @Nonnull Organization organization) {
        Arguments.checkNonEmpty((String)clonedName, (String)"clonedName");
        Arguments.checkNotNull((Object)organization, (String)"Organization");
        Organization cloned = new Organization();
        cloned.setName(clonedName);
        cloned.setDescription(organization.getDescription());
        Organization created = this.createOrganization(cloned);
        return created;
    }

    @Override
    public SecretKeysResponse getSecrets(@Nonnull Organization organization) {
        Arguments.checkNotNull((Object)organization, (String)"Organization");
        return this.getSecrets(organization.getId());
    }

    @Override
    public SecretKeysResponse getSecrets(@Nonnull String orgID) {
        Arguments.checkNonEmpty((String)orgID, (String)"Organization ID");
        Call<SecretKeysResponse> call = this.secretsService.getOrgsIDSecrets(orgID, null);
        return (SecretKeysResponse)this.execute(call);
    }

    @Override
    public void putSecrets(@Nonnull Map<String, String> secrets, @Nonnull Organization organization) {
        Arguments.checkNotNull((Object)organization, (String)"Organization");
        this.putSecrets(secrets, organization.getId());
    }

    @Override
    public void putSecrets(@Nonnull Map<String, String> secrets, @Nonnull String orgID) {
        Arguments.checkNonEmpty((String)orgID, (String)"Organization ID");
        Arguments.checkNotNull(secrets, (String)"secrets");
        Call<Void> call = this.secretsService.patchOrgsIDSecrets(orgID, secrets, null);
        this.execute(call);
    }

    @Override
    public void deleteSecrets(@Nonnull List<String> secrets, @Nonnull Organization organization) {
        Arguments.checkNotNull((Object)organization, (String)"Organization");
        Arguments.checkNotNull(secrets, (String)"secrets");
        this.deleteSecrets(secrets, organization.getId());
    }

    @Override
    public void deleteSecrets(@Nonnull List<String> secrets, @Nonnull String orgID) {
        Arguments.checkNonEmpty((String)orgID, (String)"Organization ID");
        Arguments.checkNotNull(secrets, (String)"secrets");
        SecretKeys secretKeys = new SecretKeys();
        secrets.forEach(secretKeys::addSecretsItem);
        this.deleteSecrets(secretKeys, orgID);
    }

    @Override
    public void deleteSecrets(@Nonnull SecretKeys secretKeys, @Nonnull String orgID) {
        Arguments.checkNonEmpty((String)orgID, (String)"Organization ID");
        Arguments.checkNotNull((Object)secretKeys, (String)"secretKeys");
        Call<Void> call = this.secretsService.postOrgsIDSecrets(orgID, secretKeys, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<ResourceMember> getMembers(@Nonnull Organization organization) {
        Arguments.checkNotNull((Object)organization, (String)"Organization");
        return this.getMembers(organization.getId());
    }

    @Override
    @Nonnull
    public List<ResourceMember> getMembers(@Nonnull String orgID) {
        Arguments.checkNonEmpty((String)orgID, (String)"Organization ID");
        Call<ResourceMembers> call = this.service.getOrgsIDMembers(orgID, null);
        ResourceMembers resourceMembers = (ResourceMembers)this.execute(call);
        LOG.log(Level.FINEST, "findOrganizationMembers found: {0}", resourceMembers);
        return resourceMembers.getUsers();
    }

    @Override
    @Nonnull
    public ResourceMember addMember(@Nonnull User member, @Nonnull Organization organization) {
        Arguments.checkNotNull((Object)organization, (String)"Organization");
        Arguments.checkNotNull((Object)member, (String)"member");
        return this.addMember(member.getId(), organization.getId());
    }

    @Override
    @Nonnull
    public ResourceMember addMember(@Nonnull String memberID, @Nonnull String orgID) {
        Arguments.checkNonEmpty((String)memberID, (String)"Member ID");
        Arguments.checkNonEmpty((String)orgID, (String)"Organization ID");
        AddResourceMemberRequestBody user = new AddResourceMemberRequestBody();
        user.setId(memberID);
        Call<ResourceMember> call = this.service.postOrgsIDMembers(orgID, user, null);
        return (ResourceMember)this.execute(call);
    }

    @Override
    public void deleteMember(@Nonnull User member, @Nonnull Organization organization) {
        Arguments.checkNotNull((Object)organization, (String)"Organization");
        Arguments.checkNotNull((Object)member, (String)"member");
        this.deleteMember(member.getId(), organization.getId());
    }

    @Override
    public void deleteMember(@Nonnull String memberID, @Nonnull String orgID) {
        Arguments.checkNonEmpty((String)memberID, (String)"Member ID");
        Arguments.checkNonEmpty((String)orgID, (String)"Organization ID");
        Call<Void> call = this.service.deleteOrgsIDMembersID(memberID, orgID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<ResourceOwner> getOwners(@Nonnull Organization organization) {
        Arguments.checkNotNull((Object)organization, (String)"Organization");
        return this.getOwners(organization.getId());
    }

    @Override
    @Nonnull
    public List<ResourceOwner> getOwners(@Nonnull String orgID) {
        Arguments.checkNonEmpty((String)orgID, (String)"Organization ID");
        Call<ResourceOwners> call = this.service.getOrgsIDOwners(orgID, null);
        ResourceOwners resourceMembers = (ResourceOwners)this.execute(call);
        LOG.log(Level.FINEST, "findOrganizationOwners found: {0}", resourceMembers);
        return resourceMembers.getUsers();
    }

    @Override
    @Nonnull
    public ResourceOwner addOwner(@Nonnull User owner, @Nonnull Organization organization) {
        Arguments.checkNotNull((Object)organization, (String)"Organization");
        Arguments.checkNotNull((Object)owner, (String)"owner");
        return this.addOwner(owner.getId(), organization.getId());
    }

    @Override
    @Nonnull
    public ResourceOwner addOwner(@Nonnull String ownerID, @Nonnull String orgID) {
        Arguments.checkNonEmpty((String)ownerID, (String)"Owner ID");
        Arguments.checkNonEmpty((String)orgID, (String)"Organization ID");
        AddResourceMemberRequestBody user = new AddResourceMemberRequestBody();
        user.setId(ownerID);
        Call<ResourceOwner> call = this.service.postOrgsIDOwners(orgID, user, null);
        return (ResourceOwner)this.execute(call);
    }

    @Override
    public void deleteOwner(@Nonnull User owner, @Nonnull Organization organization) {
        Arguments.checkNotNull((Object)organization, (String)"Organization");
        Arguments.checkNotNull((Object)owner, (String)"owner");
        this.deleteOwner(owner.getId(), organization.getId());
    }

    @Override
    public void deleteOwner(@Nonnull String ownerID, @Nonnull String orgID) {
        Arguments.checkNonEmpty((String)ownerID, (String)"Owner ID");
        Arguments.checkNonEmpty((String)orgID, (String)"Organization ID");
        Call<Void> call = this.service.deleteOrgsIDOwnersID(ownerID, orgID, null);
        this.execute(call);
    }
}

