/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.Arguments;
import com.influxdb.client.InfluxDBClientOptions;
import com.influxdb.client.WriteApi;
import com.influxdb.client.WriteOptions;
import com.influxdb.client.domain.WritePrecision;
import com.influxdb.client.internal.AbstractWriteClient;
import com.influxdb.client.service.WriteService;
import com.influxdb.client.write.Point;
import com.influxdb.client.write.events.AbstractWriteEvent;
import com.influxdb.client.write.events.EventListener;
import com.influxdb.client.write.events.ListenerRegistration;
import io.reactivex.Flowable;
import io.reactivex.disposables.Disposable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;

final class WriteApiImpl
extends AbstractWriteClient
implements WriteApi {
    WriteApiImpl(@Nonnull WriteOptions writeOptions, @Nonnull WriteService service, @Nonnull InfluxDBClientOptions options, Collection<AutoCloseable> autoCloseables) {
        super(writeOptions, options, writeOptions.getWriteScheduler(), service, autoCloseables);
    }

    @Override
    public void writeRecord(@Nonnull WritePrecision precision, @Nullable String record) {
        Arguments.checkNotNull((Object)this.options.getBucket(), (String)"InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        this.writeRecord(this.options.getBucket(), this.options.getOrg(), precision, record);
    }

    @Override
    public void writeRecord(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nullable String record) {
        Arguments.checkNonEmpty((String)bucket, (String)"bucket");
        Arguments.checkNonEmpty((String)org, (String)"org");
        Arguments.checkNotNull((Object)((Object)precision), (String)"WritePrecision is required");
        if (record == null) {
            return;
        }
        this.write(bucket, org, precision, (Publisher<AbstractWriteClient.BatchWriteData>)Flowable.just((Object)new AbstractWriteClient.BatchWriteDataRecord(record)));
    }

    @Override
    public void writeRecords(@Nonnull WritePrecision precision, @Nonnull List<String> records) {
        Arguments.checkNotNull((Object)this.options.getBucket(), (String)"InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        this.writeRecords(this.options.getBucket(), this.options.getOrg(), precision, records);
    }

    @Override
    public void writeRecords(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nonnull List<String> records) {
        Arguments.checkNonEmpty((String)bucket, (String)"bucket");
        Arguments.checkNonEmpty((String)org, (String)"org");
        Arguments.checkNotNull((Object)((Object)precision), (String)"WritePrecision is required");
        Arguments.checkNotNull(records, (String)"records");
        Flowable stream = Flowable.fromIterable(records).map(AbstractWriteClient.BatchWriteDataRecord::new);
        this.write(bucket, org, precision, (Publisher<AbstractWriteClient.BatchWriteData>)stream);
    }

    @Override
    public void writePoint(@Nullable Point point) {
        Arguments.checkNotNull((Object)this.options.getBucket(), (String)"InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        this.writePoint(this.options.getBucket(), this.options.getOrg(), point);
    }

    @Override
    public void writePoint(@Nonnull String bucket, @Nonnull String org, @Nullable Point point) {
        if (point == null) {
            return;
        }
        this.writePoints(bucket, org, Collections.singletonList(point));
    }

    @Override
    public void writePoints(@Nonnull List<Point> points) {
        Arguments.checkNotNull((Object)this.options.getBucket(), (String)"InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        this.writePoints(this.options.getBucket(), this.options.getOrg(), points);
    }

    @Override
    public void writePoints(@Nonnull String bucket, @Nonnull String org, @Nonnull List<Point> points) {
        Arguments.checkNonEmpty((String)bucket, (String)"bucket");
        Arguments.checkNonEmpty((String)org, (String)"org");
        Arguments.checkNotNull(points, (String)"points");
        Flowable stream = Flowable.fromIterable(points).filter(Objects::nonNull).map(point -> new AbstractWriteClient.BatchWriteDataPoint((Point)point, this.options));
        this.write(bucket, org, (Flowable<AbstractWriteClient.BatchWriteDataPoint>)stream);
    }

    @Override
    public <M> void writeMeasurement(@Nonnull WritePrecision precision, @Nullable M measurement) {
        Arguments.checkNotNull((Object)this.options.getBucket(), (String)"InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        this.writeMeasurement(this.options.getBucket(), this.options.getOrg(), precision, measurement);
    }

    @Override
    public <M> void writeMeasurement(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nullable M measurement) {
        if (measurement == null) {
            return;
        }
        this.writeMeasurements(bucket, org, precision, Collections.singletonList(measurement));
    }

    @Override
    public <M> void writeMeasurements(@Nonnull WritePrecision precision, @Nonnull List<M> measurements) {
        Arguments.checkNotNull((Object)this.options.getBucket(), (String)"InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        this.writeMeasurements(this.options.getBucket(), this.options.getOrg(), precision, measurements);
    }

    @Override
    public <M> void writeMeasurements(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nonnull List<M> measurements) {
        Arguments.checkNonEmpty((String)bucket, (String)"bucket");
        Arguments.checkNonEmpty((String)org, (String)"org");
        Arguments.checkNotNull((Object)((Object)precision), (String)"WritePrecision is required");
        Arguments.checkNotNull(measurements, (String)"records");
        Flowable stream = Flowable.fromIterable(measurements).map(it -> new AbstractWriteClient.BatchWriteDataMeasurement(it, precision, this.options, this.measurementMapper));
        this.write(bucket, org, precision, (Publisher<AbstractWriteClient.BatchWriteData>)stream);
    }

    @Override
    @Nonnull
    public <T extends AbstractWriteEvent> ListenerRegistration listenEvents(@Nonnull Class<T> eventType, @Nonnull EventListener<T> listener) {
        Arguments.checkNotNull(eventType, (String)"Type of listener");
        Arguments.checkNotNull(listener, (String)"Listener");
        Disposable subscribe = super.addEventListener(eventType).subscribe(listener::onEvent);
        return () -> ((Disposable)subscribe).dispose();
    }

    @Override
    public void close() {
        super.close();
    }
}

