/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.Arguments;
import com.influxdb.client.FindOptions;
import com.influxdb.client.NotificationRulesApi;
import com.influxdb.client.domain.HTTPNotificationEndpoint;
import com.influxdb.client.domain.HTTPNotificationRule;
import com.influxdb.client.domain.Label;
import com.influxdb.client.domain.LabelMapping;
import com.influxdb.client.domain.LabelResponse;
import com.influxdb.client.domain.LabelsResponse;
import com.influxdb.client.domain.NotificationEndpoint;
import com.influxdb.client.domain.NotificationRule;
import com.influxdb.client.domain.NotificationRuleUpdate;
import com.influxdb.client.domain.NotificationRules;
import com.influxdb.client.domain.PagerDutyNotificationEndpoint;
import com.influxdb.client.domain.PagerDutyNotificationRule;
import com.influxdb.client.domain.RuleStatusLevel;
import com.influxdb.client.domain.SlackNotificationEndpoint;
import com.influxdb.client.domain.SlackNotificationRule;
import com.influxdb.client.domain.StatusRule;
import com.influxdb.client.domain.TagRule;
import com.influxdb.client.domain.TaskStatusType;
import com.influxdb.client.service.NotificationRulesService;
import com.influxdb.internal.AbstractRestClient;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import retrofit2.Call;

final class NotificationRulesApiImpl
extends AbstractRestClient
implements NotificationRulesApi {
    private final NotificationRulesService service;

    NotificationRulesApiImpl(@Nonnull NotificationRulesService service) {
        Arguments.checkNotNull((Object)service, (String)"service");
        this.service = service;
    }

    @Override
    @Nonnull
    public SlackNotificationRule createSlackRule(@Nonnull String name, @Nonnull String every, @Nonnull String messageTemplate, @Nonnull RuleStatusLevel status, @Nonnull SlackNotificationEndpoint endpoint, @Nonnull String orgID) {
        return this.createSlackRule(name, every, messageTemplate, status, Collections.emptyList(), endpoint, orgID);
    }

    @Override
    @Nonnull
    public SlackNotificationRule createSlackRule(@Nonnull String name, @Nonnull String every, @Nonnull String messageTemplate, @Nonnull RuleStatusLevel status, @Nonnull List<TagRule> tagRules, @Nonnull SlackNotificationEndpoint endpoint, @Nonnull String orgID) {
        Arguments.checkNonEmpty((String)name, (String)"name");
        Arguments.checkDuration((String)every, (String)"every");
        Arguments.checkNonEmpty((String)messageTemplate, (String)"messageTemplate");
        Arguments.checkNotNull((Object)((Object)status), (String)"status");
        Arguments.checkNotNull(tagRules, (String)"tagRules");
        Arguments.checkNotNull((Object)endpoint, (String)"endpoint");
        Arguments.checkNonEmpty((String)orgID, (String)"orgID");
        SlackNotificationRule rule = new SlackNotificationRule();
        rule.setMessageTemplate(messageTemplate);
        return (SlackNotificationRule)this.createRule(name, every, status, tagRules, endpoint, orgID, rule);
    }

    @Override
    @Nonnull
    public PagerDutyNotificationRule createPagerDutyRule(@Nonnull String name, @Nonnull String every, @Nonnull String messageTemplate, @Nonnull RuleStatusLevel status, @Nonnull List<TagRule> tagRules, @Nonnull PagerDutyNotificationEndpoint endpoint, @Nonnull String orgID) {
        Arguments.checkNonEmpty((String)name, (String)"name");
        Arguments.checkDuration((String)every, (String)"every");
        Arguments.checkNonEmpty((String)messageTemplate, (String)"messageTemplate");
        Arguments.checkNotNull((Object)((Object)status), (String)"status");
        Arguments.checkNotNull(tagRules, (String)"tagRules");
        Arguments.checkNotNull((Object)endpoint, (String)"endpoint");
        Arguments.checkNonEmpty((String)orgID, (String)"orgID");
        PagerDutyNotificationRule rule = new PagerDutyNotificationRule();
        rule.setMessageTemplate(messageTemplate);
        return (PagerDutyNotificationRule)this.createRule(name, every, status, tagRules, endpoint, orgID, rule);
    }

    @Override
    @Nonnull
    public HTTPNotificationRule createHTTPRule(@Nonnull String name, @Nonnull String every, @Nonnull RuleStatusLevel status, @Nonnull List<TagRule> tagRules, @Nonnull HTTPNotificationEndpoint endpoint, @Nonnull String orgID) {
        HTTPNotificationRule rule = new HTTPNotificationRule();
        return (HTTPNotificationRule)this.createRule(name, every, status, tagRules, endpoint, orgID, rule);
    }

    @Override
    @Nonnull
    public NotificationRule createRule(@Nonnull NotificationRule rule) {
        Arguments.checkNotNull((Object)rule, (String)"rule");
        Call<NotificationRule> call = this.service.createNotificationRule(rule);
        return (NotificationRule)this.execute(call);
    }

    @Override
    @Nonnull
    public NotificationRule updateNotificationRule(@Nonnull NotificationRule notificationRule) {
        Arguments.checkNotNull((Object)notificationRule, (String)"update");
        NotificationRuleUpdate update = new NotificationRuleUpdate().name(notificationRule.getName()).description(notificationRule.getDescription()).status(NotificationRuleUpdate.StatusEnum.fromValue(notificationRule.getStatus().getValue()));
        return this.updateNotificationRule(notificationRule.getId(), update);
    }

    @Override
    @Nonnull
    public NotificationRule updateNotificationRule(@Nonnull String ruleID, @Nonnull NotificationRuleUpdate update) {
        Arguments.checkNotNull((Object)ruleID, (String)"ruleID");
        Arguments.checkNotNull((Object)update, (String)"update");
        Call<NotificationRule> call = this.service.patchNotificationRulesID(ruleID, update, null);
        return (NotificationRule)this.execute(call);
    }

    @Override
    public void deleteNotificationRule(@Nonnull NotificationRule notificationRule) {
        Arguments.checkNotNull((Object)notificationRule, (String)"notificationRule");
        this.deleteNotificationRule(notificationRule.getId());
    }

    @Override
    public void deleteNotificationRule(@Nonnull String ruleID) {
        Arguments.checkNotNull((Object)ruleID, (String)"ruleID");
        Call<Void> call = this.service.deleteNotificationRulesID(ruleID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public NotificationRule findNotificationRuleByID(@Nonnull String ruleID) {
        Arguments.checkNotNull((Object)ruleID, (String)"ruleID");
        Call<NotificationRule> call = this.service.getNotificationRulesID(ruleID, null);
        return (NotificationRule)this.execute(call);
    }

    @Override
    @Nonnull
    public List<NotificationRule> findNotificationRules(@Nonnull String orgID) {
        Arguments.checkNonEmpty((String)orgID, (String)"orgID");
        return this.findNotificationRules(orgID, new FindOptions()).getNotificationRules();
    }

    @Override
    @Nonnull
    public NotificationRules findNotificationRules(@Nonnull String orgID, @Nonnull FindOptions findOptions) {
        Arguments.checkNonEmpty((String)orgID, (String)"orgID");
        Arguments.checkNotNull((Object)findOptions, (String)"findOptions");
        Call<NotificationRules> call = this.service.getNotificationRules(orgID, null, findOptions.getOffset(), findOptions.getLimit(), null, null);
        return (NotificationRules)this.execute(call);
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull NotificationRule notificationRule) {
        Arguments.checkNotNull((Object)notificationRule, (String)"notificationRule");
        return this.getLabels(notificationRule.getId());
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull String ruleID) {
        Arguments.checkNonEmpty((String)ruleID, (String)"ruleID");
        Call<LabelsResponse> call = this.service.getNotificationRulesIDLabels(ruleID, null);
        return ((LabelsResponse)this.execute(call)).getLabels();
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull Label label, @Nonnull NotificationRule notificationRule) {
        Arguments.checkNotNull((Object)label, (String)"label");
        Arguments.checkNotNull((Object)notificationRule, (String)"notificationRule");
        return this.addLabel(label.getId(), notificationRule.getId());
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull String labelID, @Nonnull String ruleID) {
        Arguments.checkNonEmpty((String)labelID, (String)"labelID");
        Arguments.checkNonEmpty((String)ruleID, (String)"ruleID");
        LabelMapping labelMapping = new LabelMapping();
        labelMapping.setLabelID(labelID);
        Call<LabelResponse> call = this.service.postNotificationRuleIDLabels(ruleID, labelMapping, null);
        return (LabelResponse)this.execute(call);
    }

    @Override
    public void deleteLabel(@Nonnull Label label, @Nonnull NotificationRule notificationRule) {
        Arguments.checkNotNull((Object)label, (String)"label");
        Arguments.checkNotNull((Object)notificationRule, (String)"check");
        this.deleteLabel(label.getId(), notificationRule.getId());
    }

    @Override
    public void deleteLabel(@Nonnull String labelID, @Nonnull String ruleID) {
        Arguments.checkNonEmpty((String)labelID, (String)"labelID");
        Arguments.checkNonEmpty((String)ruleID, (String)"ruleID");
        Call<Void> call = this.service.deleteNotificationRulesIDLabelsID(ruleID, labelID, null);
        this.execute(call);
    }

    @Nonnull
    private NotificationRule createRule(@Nonnull String name, @Nonnull String every, @Nonnull RuleStatusLevel status, @Nonnull List<TagRule> tagRules, @Nonnull NotificationEndpoint notificationEndpoint, @Nonnull String orgID, @Nonnull NotificationRule rule) {
        Arguments.checkNotNull((Object)rule, (String)"rule");
        rule.setName(name);
        rule.setEvery(every);
        rule.setOrgID(orgID);
        rule.setTagRules(tagRules);
        rule.addStatusRulesItem(new StatusRule().currentLevel(status));
        rule.setEndpointID(notificationEndpoint.getId());
        rule.setStatus(TaskStatusType.ACTIVE);
        return this.createRule(rule);
    }
}

