/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.AxisScale;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The description of a particular axis for a visualization.")
public class Axis {
    public static final String SERIALIZED_NAME_BOUNDS = "bounds";
    @SerializedName(value="bounds")
    private List<String> bounds = new ArrayList<String>();
    public static final String SERIALIZED_NAME_LABEL = "label";
    @SerializedName(value="label")
    private String label;
    public static final String SERIALIZED_NAME_PREFIX = "prefix";
    @SerializedName(value="prefix")
    private String prefix;
    public static final String SERIALIZED_NAME_SUFFIX = "suffix";
    @SerializedName(value="suffix")
    private String suffix;
    public static final String SERIALIZED_NAME_BASE = "base";
    @SerializedName(value="base")
    private BaseEnum base;
    public static final String SERIALIZED_NAME_SCALE = "scale";
    @SerializedName(value="scale")
    private AxisScale scale = null;

    public Axis bounds(List<String> bounds) {
        this.bounds = bounds;
        return this;
    }

    public Axis addBoundsItem(String boundsItem) {
        if (this.bounds == null) {
            this.bounds = new ArrayList<String>();
        }
        this.bounds.add(boundsItem);
        return this;
    }

    @ApiModelProperty(value="The extents of an axis in the form [lower, upper]. Clients determine whether bounds are to be inclusive or exclusive of their limits")
    public List<String> getBounds() {
        return this.bounds;
    }

    public void setBounds(List<String> bounds) {
        this.bounds = bounds;
    }

    public Axis label(String label) {
        this.label = label;
        return this;
    }

    @ApiModelProperty(value="Label is a description of this Axis")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Axis prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @ApiModelProperty(value="Prefix represents a label prefix for formatting axis values.")
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Axis suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    @ApiModelProperty(value="Suffix represents a label suffix for formatting axis values.")
    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public Axis base(BaseEnum base) {
        this.base = base;
        return this;
    }

    @ApiModelProperty(value="Base represents the radix for formatting axis values.")
    public BaseEnum getBase() {
        return this.base;
    }

    public void setBase(BaseEnum base) {
        this.base = base;
    }

    public Axis scale(AxisScale scale) {
        this.scale = scale;
        return this;
    }

    @ApiModelProperty(value="")
    public AxisScale getScale() {
        return this.scale;
    }

    public void setScale(AxisScale scale) {
        this.scale = scale;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Axis axis = (Axis)o;
        return Objects.equals(this.bounds, axis.bounds) && Objects.equals(this.label, axis.label) && Objects.equals(this.prefix, axis.prefix) && Objects.equals(this.suffix, axis.suffix) && Objects.equals((Object)this.base, (Object)axis.base) && Objects.equals((Object)this.scale, (Object)axis.scale);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bounds, this.label, this.prefix, this.suffix, this.base, this.scale});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Axis {\n");
        sb.append("    bounds: ").append(this.toIndentedString(this.bounds)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    prefix: ").append(this.toIndentedString(this.prefix)).append("\n");
        sb.append("    suffix: ").append(this.toIndentedString(this.suffix)).append("\n");
        sb.append("    base: ").append(this.toIndentedString((Object)this.base)).append("\n");
        sb.append("    scale: ").append(this.toIndentedString((Object)this.scale)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BaseEnum {
        EMPTY(""),
        _2("2"),
        _10("10");

        private String value;

        private BaseEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BaseEnum fromValue(String text) {
            for (BaseEnum b : BaseEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<BaseEnum> {
            public void write(JsonWriter jsonWriter, BaseEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BaseEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BaseEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

