/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.influxdb.client.domain.BinaryExpression;
import com.influxdb.client.domain.BooleanLiteral;
import com.influxdb.client.domain.CallExpression;
import com.influxdb.client.domain.ConditionalExpression;
import com.influxdb.client.domain.DateTimeLiteral;
import com.influxdb.client.domain.DurationLiteral;
import com.influxdb.client.domain.Expression;
import com.influxdb.client.domain.FloatLiteral;
import com.influxdb.client.domain.FunctionExpression;
import com.influxdb.client.domain.Identifier;
import com.influxdb.client.domain.IndexExpression;
import com.influxdb.client.domain.IntegerLiteral;
import com.influxdb.client.domain.LogicalExpression;
import com.influxdb.client.domain.MemberExpression;
import com.influxdb.client.domain.ObjectExpression;
import com.influxdb.client.domain.ParenExpression;
import com.influxdb.client.domain.PipeExpression;
import com.influxdb.client.domain.PipeLiteral;
import com.influxdb.client.domain.RegexpLiteral;
import com.influxdb.client.domain.StringLiteral;
import com.influxdb.client.domain.UnaryExpression;
import com.influxdb.client.domain.UnsignedIntegerLiteral;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Used to create and directly specify the elements of an array object")
public class ArrayExpression
extends Expression {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_ELEMENTS = "elements";
    @SerializedName(value="elements")
    @JsonAdapter(value=ArrayExpressionElementsAdapter.class)
    private List<Expression> elements = new ArrayList<Expression>();

    public ArrayExpression type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Type of AST node")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ArrayExpression elements(List<Expression> elements) {
        this.elements = elements;
        return this;
    }

    public ArrayExpression addElementsItem(Expression elementsItem) {
        if (this.elements == null) {
            this.elements = new ArrayList<Expression>();
        }
        this.elements.add(elementsItem);
        return this;
    }

    @ApiModelProperty(value="Elements of the array")
    public List<Expression> getElements() {
        return this.elements;
    }

    public void setElements(List<Expression> elements) {
        this.elements = elements;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayExpression arrayExpression = (ArrayExpression)o;
        return Objects.equals(this.type, arrayExpression.type) && Objects.equals(this.elements, arrayExpression.elements) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.elements, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ArrayExpression {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    elements: ").append(this.toIndentedString(this.elements)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public class ArrayExpressionElementsAdapter
    implements JsonDeserializer<Object>,
    JsonSerializer<Object> {
        public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            List<String> discriminator = Arrays.asList(ArrayExpression.SERIALIZED_NAME_TYPE);
            ArrayList<Object> results = new ArrayList<Object>();
            for (JsonElement arrayItem : json.getAsJsonArray()) {
                JsonObject jsonObject = arrayItem.getAsJsonObject();
                String[] types = (String[])discriminator.stream().map(arg_0 -> ((JsonObject)jsonObject).get(arg_0)).filter(Objects::nonNull).map(JsonElement::getAsString).toArray(String[]::new);
                results.add(this.deserialize(types, (JsonElement)jsonObject, context));
            }
            return results;
        }

        public JsonElement serialize(Object object, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize(object);
        }

        private Object deserialize(String[] types, JsonElement json, JsonDeserializationContext context) {
            if (Arrays.equals(new String[]{"ArrayExpression"}, types)) {
                return context.deserialize(json, ArrayExpression.class);
            }
            if (Arrays.equals(new String[]{"FunctionExpression"}, types)) {
                return context.deserialize(json, FunctionExpression.class);
            }
            if (Arrays.equals(new String[]{"BinaryExpression"}, types)) {
                return context.deserialize(json, BinaryExpression.class);
            }
            if (Arrays.equals(new String[]{"CallExpression"}, types)) {
                return context.deserialize(json, CallExpression.class);
            }
            if (Arrays.equals(new String[]{"ConditionalExpression"}, types)) {
                return context.deserialize(json, ConditionalExpression.class);
            }
            if (Arrays.equals(new String[]{"LogicalExpression"}, types)) {
                return context.deserialize(json, LogicalExpression.class);
            }
            if (Arrays.equals(new String[]{"MemberExpression"}, types)) {
                return context.deserialize(json, MemberExpression.class);
            }
            if (Arrays.equals(new String[]{"IndexExpression"}, types)) {
                return context.deserialize(json, IndexExpression.class);
            }
            if (Arrays.equals(new String[]{"ObjectExpression"}, types)) {
                return context.deserialize(json, ObjectExpression.class);
            }
            if (Arrays.equals(new String[]{"ParenExpression"}, types)) {
                return context.deserialize(json, ParenExpression.class);
            }
            if (Arrays.equals(new String[]{"PipeExpression"}, types)) {
                return context.deserialize(json, PipeExpression.class);
            }
            if (Arrays.equals(new String[]{"UnaryExpression"}, types)) {
                return context.deserialize(json, UnaryExpression.class);
            }
            if (Arrays.equals(new String[]{"BooleanLiteral"}, types)) {
                return context.deserialize(json, BooleanLiteral.class);
            }
            if (Arrays.equals(new String[]{"DateTimeLiteral"}, types)) {
                return context.deserialize(json, DateTimeLiteral.class);
            }
            if (Arrays.equals(new String[]{"DurationLiteral"}, types)) {
                return context.deserialize(json, DurationLiteral.class);
            }
            if (Arrays.equals(new String[]{"FloatLiteral"}, types)) {
                return context.deserialize(json, FloatLiteral.class);
            }
            if (Arrays.equals(new String[]{"IntegerLiteral"}, types)) {
                return context.deserialize(json, IntegerLiteral.class);
            }
            if (Arrays.equals(new String[]{"PipeLiteral"}, types)) {
                return context.deserialize(json, PipeLiteral.class);
            }
            if (Arrays.equals(new String[]{"RegexpLiteral"}, types)) {
                return context.deserialize(json, RegexpLiteral.class);
            }
            if (Arrays.equals(new String[]{"StringLiteral"}, types)) {
                return context.deserialize(json, StringLiteral.class);
            }
            if (Arrays.equals(new String[]{"UnsignedIntegerLiteral"}, types)) {
                return context.deserialize(json, UnsignedIntegerLiteral.class);
            }
            if (Arrays.equals(new String[]{"Identifier"}, types)) {
                return context.deserialize(json, Identifier.class);
            }
            return context.deserialize(json, Object.class);
        }
    }
}

