/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.Dialect;
import com.influxdb.client.domain.File;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="Query influx using the Flux language")
public class Query {
    public static final String SERIALIZED_NAME_EXTERN = "extern";
    @SerializedName(value="extern")
    private File extern = null;
    public static final String SERIALIZED_NAME_QUERY = "query";
    @SerializedName(value="query")
    private String query;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type = TypeEnum.FLUX;
    public static final String SERIALIZED_NAME_DIALECT = "dialect";
    @SerializedName(value="dialect")
    private Dialect dialect = null;
    public static final String SERIALIZED_NAME_NOW = "now";
    @SerializedName(value="now")
    private OffsetDateTime now;

    public Query extern(File extern) {
        this.extern = extern;
        return this;
    }

    @ApiModelProperty(value="")
    public File getExtern() {
        return this.extern;
    }

    public void setExtern(File extern) {
        this.extern = extern;
    }

    public Query query(String query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(required=true, value="Query script to execute.")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    @ApiModelProperty(value="The type of query. Must be \"flux\".")
    public TypeEnum getType() {
        return this.type;
    }

    public Query dialect(Dialect dialect) {
        this.dialect = dialect;
        return this;
    }

    @ApiModelProperty(value="")
    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public Query now(OffsetDateTime now) {
        this.now = now;
        return this;
    }

    @ApiModelProperty(value="Specifies the time that should be reported as \"now\" in the query. Default is the server's now time.")
    public OffsetDateTime getNow() {
        return this.now;
    }

    public void setNow(OffsetDateTime now) {
        this.now = now;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query = (Query)o;
        return Objects.equals(this.extern, query.extern) && Objects.equals(this.query, query.query) && Objects.equals((Object)this.type, (Object)query.type) && Objects.equals(this.dialect, query.dialect) && Objects.equals(this.now, query.now);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.extern, this.query, this.type, this.dialect, this.now});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Query {\n");
        sb.append("    extern: ").append(this.toIndentedString(this.extern)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    dialect: ").append(this.toIndentedString(this.dialect)).append("\n");
        sb.append("    now: ").append(this.toIndentedString(this.now)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        FLUX("flux");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

