/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.Arguments;
import com.influxdb.client.FindOptions;
import com.influxdb.client.NotificationEndpointsApi;
import com.influxdb.client.domain.HTTPNotificationEndpoint;
import com.influxdb.client.domain.Label;
import com.influxdb.client.domain.LabelMapping;
import com.influxdb.client.domain.LabelResponse;
import com.influxdb.client.domain.LabelsResponse;
import com.influxdb.client.domain.NotificationEndpoint;
import com.influxdb.client.domain.NotificationEndpointBase;
import com.influxdb.client.domain.NotificationEndpointType;
import com.influxdb.client.domain.NotificationEndpointUpdate;
import com.influxdb.client.domain.NotificationEndpoints;
import com.influxdb.client.domain.PagerDutyNotificationEndpoint;
import com.influxdb.client.domain.SlackNotificationEndpoint;
import com.influxdb.client.service.NotificationEndpointsService;
import com.influxdb.internal.AbstractRestClient;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import retrofit2.Call;

final class NotificationEndpointsApiImpl
extends AbstractRestClient
implements NotificationEndpointsApi {
    private final NotificationEndpointsService service;

    NotificationEndpointsApiImpl(@Nonnull NotificationEndpointsService service) {
        Arguments.checkNotNull((Object)service, (String)"notificationEndpointsService");
        this.service = service;
    }

    @Override
    @Nonnull
    public SlackNotificationEndpoint createSlackEndpoint(@Nonnull String name, @Nonnull String url, @Nonnull String orgID) {
        Arguments.checkNotNull((Object)url, (String)"url");
        return this.createSlackEndpoint(name, url, null, orgID);
    }

    @Override
    @Nonnull
    public SlackNotificationEndpoint createSlackEndpoint(@Nonnull String name, @Nullable String url, @Nullable String token, @Nonnull String orgID) {
        Arguments.checkNonEmpty((String)name, (String)"name");
        Arguments.checkNonEmpty((String)orgID, (String)"orgID");
        SlackNotificationEndpoint endpoint = new SlackNotificationEndpoint();
        endpoint.setType(NotificationEndpointType.SLACK);
        endpoint.setUrl(url);
        endpoint.setToken(token);
        endpoint.orgID(orgID);
        endpoint.setName(name);
        endpoint.setStatus(NotificationEndpointBase.StatusEnum.ACTIVE);
        return (SlackNotificationEndpoint)this.createEndpoint(endpoint);
    }

    @Override
    @Nonnull
    public PagerDutyNotificationEndpoint createPagerDutyEndpoint(@Nonnull String name, @Nonnull String clientURL, @Nonnull String routingKey, @Nonnull String orgID) {
        Arguments.checkNonEmpty((String)name, (String)"name");
        Arguments.checkNonEmpty((String)clientURL, (String)"clientURL");
        Arguments.checkNonEmpty((String)routingKey, (String)"routingKey");
        Arguments.checkNonEmpty((String)orgID, (String)"orgID");
        PagerDutyNotificationEndpoint endpoint = new PagerDutyNotificationEndpoint();
        endpoint.setType(NotificationEndpointType.PAGERDUTY);
        endpoint.setClientURL(clientURL);
        endpoint.setRoutingKey(routingKey);
        endpoint.orgID(orgID);
        endpoint.setName(name);
        endpoint.setStatus(NotificationEndpointBase.StatusEnum.ACTIVE);
        return (PagerDutyNotificationEndpoint)this.createEndpoint(endpoint);
    }

    @Override
    @Nonnull
    public HTTPNotificationEndpoint createHTTPEndpoint(@Nonnull String name, @Nonnull String url, @Nonnull HTTPNotificationEndpoint.MethodEnum method, @Nonnull String orgID) {
        Arguments.checkNonEmpty((String)name, (String)"name");
        Arguments.checkNonEmpty((String)url, (String)"url");
        Arguments.checkNotNull((Object)((Object)method), (String)"method");
        Arguments.checkNonEmpty((String)orgID, (String)"orgID");
        HTTPNotificationEndpoint endpoint = new HTTPNotificationEndpoint();
        endpoint.setType(NotificationEndpointType.HTTP);
        endpoint.setMethod(method);
        endpoint.setUrl(url);
        endpoint.orgID(orgID);
        endpoint.setName(name);
        endpoint.setAuthMethod(HTTPNotificationEndpoint.AuthMethodEnum.NONE);
        endpoint.setStatus(NotificationEndpointBase.StatusEnum.ACTIVE);
        return (HTTPNotificationEndpoint)this.createEndpoint(endpoint);
    }

    @Override
    @Nonnull
    public HTTPNotificationEndpoint createHTTPEndpointBasicAuth(@Nonnull String name, @Nonnull String url, @Nonnull HTTPNotificationEndpoint.MethodEnum method, @Nonnull String username, @Nonnull String password, @Nonnull String orgID) {
        Arguments.checkNonEmpty((String)name, (String)"name");
        Arguments.checkNonEmpty((String)url, (String)"url");
        Arguments.checkNotNull((Object)((Object)method), (String)"method");
        Arguments.checkNonEmpty((String)username, (String)"username");
        Arguments.checkNonEmpty((String)password, (String)"password");
        Arguments.checkNonEmpty((String)orgID, (String)"orgID");
        HTTPNotificationEndpoint endpoint = new HTTPNotificationEndpoint();
        endpoint.setType(NotificationEndpointType.HTTP);
        endpoint.setMethod(method);
        endpoint.setUrl(url);
        endpoint.orgID(orgID);
        endpoint.setName(name);
        endpoint.setUsername(username);
        endpoint.setPassword(password);
        endpoint.setAuthMethod(HTTPNotificationEndpoint.AuthMethodEnum.BASIC);
        endpoint.setStatus(NotificationEndpointBase.StatusEnum.ACTIVE);
        return (HTTPNotificationEndpoint)this.createEndpoint(endpoint);
    }

    @Override
    @Nonnull
    public HTTPNotificationEndpoint createHTTPEndpointBearer(@Nonnull String name, @Nonnull String url, @Nonnull HTTPNotificationEndpoint.MethodEnum method, @Nonnull String token, @Nonnull String orgID) {
        Arguments.checkNonEmpty((String)name, (String)"name");
        Arguments.checkNonEmpty((String)url, (String)"url");
        Arguments.checkNotNull((Object)((Object)method), (String)"method");
        Arguments.checkNonEmpty((String)token, (String)"token");
        Arguments.checkNonEmpty((String)orgID, (String)"orgID");
        HTTPNotificationEndpoint endpoint = new HTTPNotificationEndpoint();
        endpoint.setType(NotificationEndpointType.HTTP);
        endpoint.setMethod(method);
        endpoint.setUrl(url);
        endpoint.orgID(orgID);
        endpoint.setName(name);
        endpoint.setToken(token);
        endpoint.setAuthMethod(HTTPNotificationEndpoint.AuthMethodEnum.BEARER);
        endpoint.setStatus(NotificationEndpointBase.StatusEnum.ACTIVE);
        return (HTTPNotificationEndpoint)this.createEndpoint(endpoint);
    }

    @Override
    @Nonnull
    public NotificationEndpoint createEndpoint(@Nonnull NotificationEndpoint notificationEndpoint) {
        Arguments.checkNotNull((Object)notificationEndpoint, (String)"notificationEndpoint");
        Call<NotificationEndpoint> endpointCall = this.service.createNotificationEndpoint(notificationEndpoint);
        return (NotificationEndpoint)this.execute(endpointCall);
    }

    @Override
    @Nonnull
    public NotificationEndpoint updateEndpoint(@Nonnull NotificationEndpoint notificationEndpoint) {
        Arguments.checkNotNull((Object)notificationEndpoint, (String)"notificationEndpoint");
        NotificationEndpointUpdate update = new NotificationEndpointUpdate().name(notificationEndpoint.getName()).description(notificationEndpoint.getDescription()).status(NotificationEndpointUpdate.StatusEnum.fromValue(notificationEndpoint.getStatus().getValue()));
        return this.updateEndpoint(notificationEndpoint.getId(), update);
    }

    @Override
    @Nonnull
    public NotificationEndpoint updateEndpoint(@Nonnull String endpointID, @Nonnull NotificationEndpointUpdate notificationEndpointUpdate) {
        Arguments.checkNonEmpty((String)endpointID, (String)"endpointID");
        Arguments.checkNotNull((Object)notificationEndpointUpdate, (String)"notificationEndpointUpdate");
        Call<NotificationEndpoint> endpointCall = this.service.patchNotificationEndpointsID(endpointID, notificationEndpointUpdate, null);
        return (NotificationEndpoint)this.execute(endpointCall);
    }

    @Override
    public void deleteNotificationEndpoint(@Nonnull NotificationEndpoint notificationEndpoint) {
        Arguments.checkNotNull((Object)notificationEndpoint, (String)"notificationEndpoint");
        this.deleteNotificationEndpoint(notificationEndpoint.getId());
    }

    @Override
    public void deleteNotificationEndpoint(@Nonnull String endpointID) {
        Arguments.checkNonEmpty((String)endpointID, (String)"endpointID");
        Call<Void> endpointCall = this.service.deleteNotificationEndpointsID(endpointID, null);
        this.execute(endpointCall);
    }

    @Override
    @Nonnull
    public List<NotificationEndpoint> findNotificationEndpoints(@Nonnull String orgID) {
        Arguments.checkNonEmpty((String)orgID, (String)"orgID");
        return this.findNotificationEndpoints(orgID, new FindOptions()).getNotificationEndpoints();
    }

    @Override
    @Nonnull
    public NotificationEndpoints findNotificationEndpoints(@Nonnull String orgID, @Nonnull FindOptions findOptions) {
        Arguments.checkNonEmpty((String)orgID, (String)"orgID");
        Arguments.checkNotNull((Object)findOptions, (String)"findOptions");
        Call<NotificationEndpoints> endpointCall = this.service.getNotificationEndpoints(orgID, null, findOptions.getOffset(), findOptions.getLimit());
        return (NotificationEndpoints)this.execute(endpointCall);
    }

    @Override
    @Nonnull
    public SlackNotificationEndpoint cloneSlackEndpoint(@Nonnull String name, @Nullable String token, @Nonnull String endpointID) {
        Arguments.checkNonEmpty((String)name, (String)"name");
        Arguments.checkNotNull((Object)endpointID, (String)"endpointID");
        return this.cloneSlackEndpoint(name, token, (SlackNotificationEndpoint)this.findNotificationEndpointByID(endpointID));
    }

    @Override
    @Nonnull
    public SlackNotificationEndpoint cloneSlackEndpoint(@Nonnull String name, @Nullable String token, @Nonnull SlackNotificationEndpoint endpoint) {
        Arguments.checkNonEmpty((String)name, (String)"name");
        Arguments.checkNotNull((Object)endpoint, (String)"endpoint");
        SlackNotificationEndpoint cloned = new SlackNotificationEndpoint().url(endpoint.getUrl()).token(token);
        return (SlackNotificationEndpoint)this.cloneEndpoint(name, endpoint, cloned);
    }

    @Override
    @Nonnull
    public PagerDutyNotificationEndpoint clonePagerDutyEndpoint(@Nonnull String name, @Nonnull String routingKey, @Nonnull String endpointID) {
        Arguments.checkNonEmpty((String)name, (String)"name");
        Arguments.checkNonEmpty((String)routingKey, (String)"routingKey");
        Arguments.checkNonEmpty((String)endpointID, (String)"endpointID");
        return this.clonePagerDutyEndpoint(name, routingKey, (PagerDutyNotificationEndpoint)this.findNotificationEndpointByID(endpointID));
    }

    @Override
    @Nonnull
    public PagerDutyNotificationEndpoint clonePagerDutyEndpoint(@Nonnull String name, @Nonnull String routingKey, @Nonnull PagerDutyNotificationEndpoint endpoint) {
        Arguments.checkNonEmpty((String)name, (String)"name");
        Arguments.checkNonEmpty((String)routingKey, (String)"routingKey");
        Arguments.checkNotNull((Object)endpoint, (String)"endpoint");
        PagerDutyNotificationEndpoint cloned = new PagerDutyNotificationEndpoint().clientURL(endpoint.getClientURL()).routingKey(routingKey);
        return (PagerDutyNotificationEndpoint)this.cloneEndpoint(name, endpoint, cloned);
    }

    @Override
    @Nonnull
    public HTTPNotificationEndpoint cloneHTTPEndpoint(@Nonnull String name, @Nonnull String endpointID) {
        Arguments.checkNonEmpty((String)name, (String)"name");
        Arguments.checkNonEmpty((String)endpointID, (String)"endpointID");
        return this.cloneHTTPEndpoint(name, (HTTPNotificationEndpoint)this.findNotificationEndpointByID(endpointID));
    }

    @Override
    @Nonnull
    public HTTPNotificationEndpoint cloneHTTPEndpoint(@Nonnull String name, @Nonnull HTTPNotificationEndpoint endpoint) {
        Arguments.checkNonEmpty((String)name, (String)"name");
        Arguments.checkNotNull((Object)endpoint, (String)"endpoint");
        HTTPNotificationEndpoint cloned = new HTTPNotificationEndpoint().url(endpoint.getUrl()).method(endpoint.getMethod()).authMethod(HTTPNotificationEndpoint.AuthMethodEnum.NONE).contentTemplate(endpoint.getContentTemplate()).headers(endpoint.getHeaders());
        return (HTTPNotificationEndpoint)this.cloneEndpoint(name, endpoint, cloned);
    }

    @Override
    @Nonnull
    public HTTPNotificationEndpoint cloneHTTPEndpointBasicAuth(@Nonnull String name, @Nonnull String username, @Nonnull String password, @Nonnull String endpointID) {
        Arguments.checkNonEmpty((String)name, (String)"name");
        Arguments.checkNonEmpty((String)username, (String)"username");
        Arguments.checkNonEmpty((String)password, (String)"password");
        Arguments.checkNonEmpty((String)endpointID, (String)"endpointID");
        return this.cloneHTTPEndpointBasicAuth(name, username, password, (HTTPNotificationEndpoint)this.findNotificationEndpointByID(endpointID));
    }

    @Override
    @Nonnull
    public HTTPNotificationEndpoint cloneHTTPEndpointBasicAuth(@Nonnull String name, @Nonnull String username, @Nonnull String password, @Nonnull HTTPNotificationEndpoint endpoint) {
        Arguments.checkNonEmpty((String)name, (String)"name");
        Arguments.checkNonEmpty((String)username, (String)"username");
        Arguments.checkNonEmpty((String)password, (String)"password");
        Arguments.checkNotNull((Object)endpoint, (String)"endpoint");
        HTTPNotificationEndpoint cloned = new HTTPNotificationEndpoint().url(endpoint.getUrl()).username(username).password(password).method(endpoint.getMethod()).authMethod(HTTPNotificationEndpoint.AuthMethodEnum.BASIC).contentTemplate(endpoint.getContentTemplate()).headers(endpoint.getHeaders());
        return (HTTPNotificationEndpoint)this.cloneEndpoint(name, endpoint, cloned);
    }

    @Override
    @Nonnull
    public HTTPNotificationEndpoint cloneHTTPEndpointBearer(@Nonnull String name, @Nonnull String token, @Nonnull String endpointID) {
        Arguments.checkNonEmpty((String)name, (String)"name");
        Arguments.checkNonEmpty((String)token, (String)"token");
        Arguments.checkNonEmpty((String)endpointID, (String)"endpointID");
        return this.cloneHTTPEndpointBearer(name, token, (HTTPNotificationEndpoint)this.findNotificationEndpointByID(endpointID));
    }

    @Override
    @Nonnull
    public HTTPNotificationEndpoint cloneHTTPEndpointBearer(@Nonnull String name, @Nonnull String token, @Nonnull HTTPNotificationEndpoint endpoint) {
        Arguments.checkNonEmpty((String)name, (String)"name");
        Arguments.checkNonEmpty((String)token, (String)"token");
        Arguments.checkNotNull((Object)endpoint, (String)"endpoint");
        HTTPNotificationEndpoint cloned = new HTTPNotificationEndpoint().url(endpoint.getUrl()).token(token).method(endpoint.getMethod()).authMethod(HTTPNotificationEndpoint.AuthMethodEnum.BEARER).contentTemplate(endpoint.getContentTemplate()).headers(endpoint.getHeaders());
        return (HTTPNotificationEndpoint)this.cloneEndpoint(name, endpoint, cloned);
    }

    @Nonnull
    private NotificationEndpoint cloneEndpoint(@Nonnull String name, @Nonnull NotificationEndpoint toCloneEndpoint, @Nonnull NotificationEndpoint clonedEndpoint) {
        Arguments.checkNonEmpty((String)name, (String)"name");
        Arguments.checkNotNull((Object)toCloneEndpoint, (String)"notificationEndpoint");
        clonedEndpoint.name(name).orgID(toCloneEndpoint.getOrgID()).description(toCloneEndpoint.getDescription()).status(toCloneEndpoint.getStatus()).type(toCloneEndpoint.getType());
        NotificationEndpoint created = this.createEndpoint(clonedEndpoint);
        this.getLabels(created).forEach(label -> this.addLabel((Label)label, created));
        return created;
    }

    @Override
    @Nonnull
    public NotificationEndpoint findNotificationEndpointByID(@Nonnull String endpointID) {
        Arguments.checkNonEmpty((String)endpointID, (String)"endpointID");
        Call<NotificationEndpoint> endpointCall = this.service.getNotificationEndpointsID(endpointID, null);
        return (NotificationEndpoint)this.execute(endpointCall);
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull NotificationEndpoint endpoint) {
        Arguments.checkNotNull((Object)endpoint, (String)"endpoint");
        return this.getLabels(endpoint.getId());
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull String endpointID) {
        Arguments.checkNonEmpty((String)endpointID, (String)"endpointID");
        Call<LabelsResponse> call = this.service.getNotificationEndpointsIDLabels(endpointID, null);
        return ((LabelsResponse)this.execute(call)).getLabels();
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull Label label, @Nonnull NotificationEndpoint endpoint) {
        Arguments.checkNotNull((Object)label, (String)"label");
        Arguments.checkNotNull((Object)endpoint, (String)"endpoint");
        return this.addLabel(label.getId(), endpoint.getId());
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull String labelID, @Nonnull String endpointID) {
        Arguments.checkNonEmpty((String)labelID, (String)"labelID");
        Arguments.checkNonEmpty((String)endpointID, (String)"endpointID");
        LabelMapping labelMapping = new LabelMapping();
        labelMapping.setLabelID(labelID);
        Call<LabelResponse> call = this.service.postNotificationEndpointIDLabels(endpointID, labelMapping, null);
        return (LabelResponse)this.execute(call);
    }

    @Override
    public void deleteLabel(@Nonnull Label label, @Nonnull NotificationEndpoint endpoint) {
        Arguments.checkNotNull((Object)label, (String)"label");
        Arguments.checkNotNull((Object)endpoint, (String)"bucket");
        this.deleteLabel(label.getId(), endpoint.getId());
    }

    @Override
    public void deleteLabel(@Nonnull String labelID, @Nonnull String endpointID) {
        Arguments.checkNonEmpty((String)labelID, (String)"labelID");
        Arguments.checkNonEmpty((String)endpointID, (String)"endpointID");
        Call<Void> call = this.service.deleteNotificationEndpointsIDLabelsID(endpointID, labelID, null);
        this.execute(call);
    }
}

