/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.annotations.SerializedName;
import com.influxdb.client.domain.Label;
import com.influxdb.client.domain.TaskLinks;
import com.influxdb.client.domain.TaskStatusType;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Task {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_ORG_I_D = "orgID";
    @SerializedName(value="orgID")
    private String orgID;
    public static final String SERIALIZED_NAME_ORG = "org";
    @SerializedName(value="org")
    private String org;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private TaskStatusType status = null;
    public static final String SERIALIZED_NAME_LABELS = "labels";
    @SerializedName(value="labels")
    private List<Label> labels = new ArrayList<Label>();
    public static final String SERIALIZED_NAME_AUTHORIZATION_I_D = "authorizationID";
    @SerializedName(value="authorizationID")
    private String authorizationID;
    public static final String SERIALIZED_NAME_FLUX = "flux";
    @SerializedName(value="flux")
    private String flux;
    public static final String SERIALIZED_NAME_EVERY = "every";
    @SerializedName(value="every")
    private String every;
    public static final String SERIALIZED_NAME_CRON = "cron";
    @SerializedName(value="cron")
    private String cron;
    public static final String SERIALIZED_NAME_OFFSET = "offset";
    @SerializedName(value="offset")
    private String offset;
    public static final String SERIALIZED_NAME_LATEST_COMPLETED = "latestCompleted";
    @SerializedName(value="latestCompleted")
    private OffsetDateTime latestCompleted;
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updatedAt";
    @SerializedName(value="updatedAt")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_LINKS = "links";
    @SerializedName(value="links")
    private TaskLinks links = null;

    @ApiModelProperty(required=true, value="")
    public String getId() {
        return this.id;
    }

    public Task type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of task, this can be used for filtering tasks on list actions.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Task orgID(String orgID) {
        this.orgID = orgID;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the organization that owns this Task.")
    public String getOrgID() {
        return this.orgID;
    }

    public void setOrgID(String orgID) {
        this.orgID = orgID;
    }

    public Task org(String org) {
        this.org = org;
        return this;
    }

    @ApiModelProperty(value="The name of the organization that owns this Task.")
    public String getOrg() {
        return this.org;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public Task name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the task.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Task description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="An optional description of the task.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Task status(TaskStatusType status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="")
    public TaskStatusType getStatus() {
        return this.status;
    }

    public void setStatus(TaskStatusType status) {
        this.status = status;
    }

    public Task labels(List<Label> labels) {
        this.labels = labels;
        return this;
    }

    public Task addLabelsItem(Label labelsItem) {
        if (this.labels == null) {
            this.labels = new ArrayList<Label>();
        }
        this.labels.add(labelsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Label> getLabels() {
        return this.labels;
    }

    public void setLabels(List<Label> labels) {
        this.labels = labels;
    }

    public Task authorizationID(String authorizationID) {
        this.authorizationID = authorizationID;
        return this;
    }

    @ApiModelProperty(value="The ID of the authorization used when this task communicates with the query engine.")
    public String getAuthorizationID() {
        return this.authorizationID;
    }

    public void setAuthorizationID(String authorizationID) {
        this.authorizationID = authorizationID;
    }

    public Task flux(String flux) {
        this.flux = flux;
        return this;
    }

    @ApiModelProperty(required=true, value="The Flux script to run for this task.")
    public String getFlux() {
        return this.flux;
    }

    public void setFlux(String flux) {
        this.flux = flux;
    }

    public Task every(String every) {
        this.every = every;
        return this;
    }

    @ApiModelProperty(value="A simple task repetition schedule; parsed from Flux.")
    public String getEvery() {
        return this.every;
    }

    public void setEvery(String every) {
        this.every = every;
    }

    public Task cron(String cron) {
        this.cron = cron;
        return this;
    }

    @ApiModelProperty(value="A task repetition schedule in the form '* * * * * *'; parsed from Flux.")
    public String getCron() {
        return this.cron;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public Task offset(String offset) {
        this.offset = offset;
        return this;
    }

    @ApiModelProperty(value="Duration to delay after the schedule, before executing the task; parsed from flux, if set to zero it will remove this option and use 0 as the default.")
    public String getOffset() {
        return this.offset;
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    @ApiModelProperty(value="Timestamp of latest scheduled, completed run, RFC3339.")
    public OffsetDateTime getLatestCompleted() {
        return this.latestCompleted;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public Task links(TaskLinks links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    public TaskLinks getLinks() {
        return this.links;
    }

    public void setLinks(TaskLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Task task = (Task)o;
        return Objects.equals(this.id, task.id) && Objects.equals(this.type, task.type) && Objects.equals(this.orgID, task.orgID) && Objects.equals(this.org, task.org) && Objects.equals(this.name, task.name) && Objects.equals(this.description, task.description) && Objects.equals((Object)this.status, (Object)task.status) && Objects.equals(this.labels, task.labels) && Objects.equals(this.authorizationID, task.authorizationID) && Objects.equals(this.flux, task.flux) && Objects.equals(this.every, task.every) && Objects.equals(this.cron, task.cron) && Objects.equals(this.offset, task.offset) && Objects.equals(this.latestCompleted, task.latestCompleted) && Objects.equals(this.createdAt, task.createdAt) && Objects.equals(this.updatedAt, task.updatedAt) && Objects.equals(this.links, task.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.orgID, this.org, this.name, this.description, this.status, this.labels, this.authorizationID, this.flux, this.every, this.cron, this.offset, this.latestCompleted, this.createdAt, this.updatedAt, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Task {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    orgID: ").append(this.toIndentedString(this.orgID)).append("\n");
        sb.append("    org: ").append(this.toIndentedString(this.org)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    authorizationID: ").append(this.toIndentedString(this.authorizationID)).append("\n");
        sb.append("    flux: ").append(this.toIndentedString(this.flux)).append("\n");
        sb.append("    every: ").append(this.toIndentedString(this.every)).append("\n");
        sb.append("    cron: ").append(this.toIndentedString(this.cron)).append("\n");
        sb.append("    offset: ").append(this.toIndentedString(this.offset)).append("\n");
        sb.append("    latestCompleted: ").append(this.toIndentedString(this.latestCompleted)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

