/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.annotations.SerializedName;
import com.influxdb.client.domain.OperationLogLinks;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

public class OperationLog {
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_TIME = "time";
    @SerializedName(value="time")
    private OffsetDateTime time;
    public static final String SERIALIZED_NAME_USER_I_D = "userID";
    @SerializedName(value="userID")
    private String userID;
    public static final String SERIALIZED_NAME_LINKS = "links";
    @SerializedName(value="links")
    private OperationLogLinks links = null;

    public OperationLog description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="Bucket Created", value="A description of the event that occurred.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OperationLog time(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    @ApiModelProperty(value="Time event occurred, RFC3339Nano.")
    public OffsetDateTime getTime() {
        return this.time;
    }

    public void setTime(OffsetDateTime time) {
        this.time = time;
    }

    public OperationLog userID(String userID) {
        this.userID = userID;
        return this;
    }

    @ApiModelProperty(value="ID of the user who operated the event.")
    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public OperationLog links(OperationLogLinks links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    public OperationLogLinks getLinks() {
        return this.links;
    }

    public void setLinks(OperationLogLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationLog operationLog = (OperationLog)o;
        return Objects.equals(this.description, operationLog.description) && Objects.equals(this.time, operationLog.time) && Objects.equals(this.userID, operationLog.userID) && Objects.equals(this.links, operationLog.links);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.time, this.userID, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationLog {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    userID: ").append(this.toIndentedString(this.userID)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

