/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query;

import com.influxdb.utils.Arguments;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class InfluxQLQueryResult {
    private final List<Result> results;

    public InfluxQLQueryResult(@Nonnull List<Result> results) {
        Arguments.checkNotNull(results, (String)"results");
        this.results = results;
    }

    @Nonnull
    public List<Result> getResults() {
        return this.results;
    }

    public static final class Series {
        @Nonnull
        private final Map<String, String> tags;
        @Nonnull
        private final Map<String, Integer> columns;
        @Nonnull
        private final String name;
        private final List<Record> values;

        public Series(@Nonnull String name, @Nonnull Map<String, Integer> columns) {
            this(name, new HashMap<String, String>(), columns);
        }

        public Series(@Nonnull String name, @Nonnull Map<String, String> tags, @Nonnull Map<String, Integer> columns) {
            Arguments.checkNotNull((Object)name, (String)"name");
            Arguments.checkNotNull(tags, (String)"tags");
            Arguments.checkNotNull(columns, (String)"columns");
            this.name = name;
            this.tags = tags;
            this.columns = columns;
            this.values = new ArrayList<Record>();
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nonnull
        public Map<String, String> getTags() {
            return this.tags;
        }

        @Nonnull
        public Map<String, Integer> getColumns() {
            return this.columns;
        }

        @Nonnull
        public List<Record> getValues() {
            return this.values;
        }

        public void addRecord(@Nonnull Record record) {
            Arguments.checkNotNull((Object)record, (String)"record");
            this.values.add(record);
        }

        public final class Record {
            private final Object[] values;

            public Record(Object[] values) {
                this.values = values;
            }

            @Nullable
            public Object getValueByKey(@Nonnull String key) {
                Arguments.checkNonEmpty((String)key, (String)"key");
                Integer index = Series.this.columns.get(key);
                if (index == null) {
                    return null;
                }
                return this.values[index];
            }

            public Object[] getValues() {
                return this.values;
            }
        }

        @FunctionalInterface
        public static interface ValueExtractor {
            @Nullable
            public Object extractValue(@Nonnull String var1, @Nonnull String var2, int var3, @Nonnull String var4);
        }
    }

    public static final class Result {
        private final List<Series> series;
        private final int index;

        public Result(int index, @Nonnull List<Series> series) {
            Arguments.checkNotNull(series, (String)"series");
            this.index = index;
            this.series = series;
        }

        public int getIndex() {
            return this.index;
        }

        @Nonnull
        public List<Series> getSeries() {
            return this.series;
        }
    }
}

