/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.exceptions;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.ResponseBody;
import org.json.JSONObject;
import retrofit2.HttpException;
import retrofit2.Response;

public class InfluxException
extends RuntimeException {
    private static final Logger LOG = Logger.getLogger(InfluxException.class.getName());
    private final Response<?> response;
    private final String message;
    private JSONObject errorBody = new JSONObject();

    public InfluxException(@Nullable String message) {
        this.response = null;
        this.message = message;
    }

    public InfluxException(@Nullable Throwable cause) {
        super(cause);
        this.response = cause instanceof HttpException ? ((HttpException)cause).response() : null;
        this.message = this.messageFromResponse();
    }

    public InfluxException(@Nullable Response<?> cause) {
        this.response = cause;
        this.message = this.messageFromResponse();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public int reference() {
        String reference = null;
        if (this.response != null) {
            reference = this.response.headers().get("X-Influx-Reference");
        }
        if (reference != null) {
            return Integer.valueOf(reference);
        }
        return 0;
    }

    public int status() {
        if (this.response != null) {
            return this.response.code();
        }
        return 0;
    }

    @Nonnull
    public JSONObject errorBody() {
        return this.errorBody;
    }

    @Nullable
    private String messageFromResponse() {
        Throwable cause;
        if (this.response != null) {
            try {
                ResponseBody body = this.response.errorBody();
                if (body != null) {
                    this.errorBody = new JSONObject(body.source().readUtf8());
                    if (this.errorBody.has("message")) {
                        return this.errorBody.getString("message");
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.FINEST, "Can't parse msg from response {}", this.response);
            }
            String value = Stream.of("X-Platform-Error-Code", "X-Influx-Error", "X-InfluxDb-Error").map(name -> this.response.headers().get(name)).filter(message -> message != null && !message.isEmpty()).findFirst().orElse(null);
            if (value != null) {
                return value;
            }
        }
        if ((cause = this.getCause()) != null) {
            return cause.getMessage();
        }
        return null;
    }
}

