/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query;

import com.influxdb.Arguments;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class FluxRecord {
    private final Integer table;
    private LinkedHashMap<String, Object> values = new LinkedHashMap();

    public FluxRecord(@Nonnull Integer table) {
        Arguments.checkNotNull(table, "Table index");
        this.table = table;
    }

    @Nullable
    public Instant getStart() {
        return (Instant)this.getValueByKey("_start");
    }

    @Nullable
    public Instant getStop() {
        return (Instant)this.getValueByKey("_stop");
    }

    @Nullable
    public Instant getTime() {
        return (Instant)this.getValueByKey("_time");
    }

    @Nullable
    public Object getValue() {
        return this.getValueByKey("_value");
    }

    @Nullable
    public String getField() {
        return (String)this.getValueByKey("_field");
    }

    @Nullable
    public String getMeasurement() {
        return (String)this.getValueByKey("_measurement");
    }

    @Nonnull
    public Integer getTable() {
        return this.table;
    }

    @Nonnull
    public Map<String, Object> getValues() {
        return this.values;
    }

    @Nullable
    public Object getValueByIndex(int index) {
        return this.values.values().toArray()[index];
    }

    @Nullable
    public Object getValueByKey(@Nonnull String key) {
        Arguments.checkNonEmpty(key, "key");
        return this.values.get(key);
    }

    public String toString() {
        return new StringJoiner(", ", FluxRecord.class.getSimpleName() + "[", "]").add("table=" + this.table).add("values=" + this.values.size()).toString();
    }
}

