/*
 * Decompiled with CFR 0.152.
 */
package com.indvd00m.ascii.render.elements.plot.misc;

import com.indvd00m.ascii.render.elements.plot.api.IPlotPoint;
import com.indvd00m.ascii.render.elements.plot.api.IPlotPoints;
import com.indvd00m.ascii.render.elements.plot.misc.PlotPoint;
import java.util.ArrayList;
import java.util.List;

public class PlotPoints
implements IPlotPoints {
    protected List<IPlotPoint> plotPoints;
    protected double maxX = Double.MIN_VALUE;
    protected double maxY = Double.MIN_VALUE;
    protected double minX = Double.MAX_VALUE;
    protected double minY = Double.MAX_VALUE;
    protected double diffX;
    protected double diffY;

    public PlotPoints(List<IPlotPoint> plotPoints) {
        this.plotPoints = plotPoints;
        for (IPlotPoint plotPoint : plotPoints) {
            if (this.maxX < plotPoint.getX()) {
                this.maxX = plotPoint.getX();
            }
            if (this.maxY < plotPoint.getY()) {
                this.maxY = plotPoint.getY();
            }
            if (this.minX > plotPoint.getX()) {
                this.minX = plotPoint.getX();
            }
            if (!(this.minY > plotPoint.getY())) continue;
            this.minY = plotPoint.getY();
        }
        this.diffX = this.maxX - this.minX;
        this.diffY = this.maxY - this.minY;
    }

    @Override
    public List<IPlotPoint> normalize(double maxX, double maxY) {
        ArrayList<IPlotPoint> normalized = new ArrayList<IPlotPoint>();
        for (IPlotPoint plotPoint : this.plotPoints) {
            double x = plotPoint.getX() - this.minX;
            double y = plotPoint.getY() - this.minY;
            double relativeX = x / this.diffX;
            double relativeY = y / this.diffY;
            double normalizedX = relativeX * maxX;
            double normalizedY = relativeY * maxY;
            PlotPoint normalizedPoint = new PlotPoint(normalizedX, normalizedY);
            normalized.add(normalizedPoint);
        }
        return normalized;
    }

    @Override
    public List<IPlotPoint> getPoints() {
        return this.plotPoints;
    }

    @Override
    public double getMaxX() {
        return this.maxX;
    }

    @Override
    public double getMaxY() {
        return this.maxY;
    }

    @Override
    public double getMinX() {
        return this.minX;
    }

    @Override
    public double getMinY() {
        return this.minY;
    }

    @Override
    public double getDiffX() {
        return this.diffX;
    }

    @Override
    public double getDiffY() {
        return this.diffY;
    }
}

