/*
 * Decompiled with CFR 0.152.
 */
package com.indvd00m.ascii.render.elements.plot.misc;

import com.indvd00m.ascii.render.api.ICanvas;
import com.indvd00m.ascii.render.api.IContext;
import com.indvd00m.ascii.render.api.IPoint;
import com.indvd00m.ascii.render.elements.Label;
import com.indvd00m.ascii.render.elements.plot.api.AxisType;

public class AxisLabel
extends Label {
    protected AxisType axisType;
    protected IPoint anchorPoint;

    public AxisLabel(String text, int x, int y, AxisType axisType, IPoint anchorPoint) {
        super(text, x, y, text.length());
        this.axisType = axisType;
        this.anchorPoint = anchorPoint;
    }

    @Override
    public IPoint draw(ICanvas canvas, IContext context) {
        super.draw(canvas, context);
        return this.anchorPoint;
    }

    public AxisType getAxisType() {
        return this.axisType;
    }

    public IPoint getAnchorPoint() {
        return this.anchorPoint;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AxisLabel [");
        if (this.axisType != null) {
            builder.append("axisType=");
            builder.append((Object)this.axisType);
            builder.append(", ");
        }
        if (this.anchorPoint != null) {
            builder.append("anchorPoint=");
            builder.append(this.anchorPoint);
            builder.append(", ");
        }
        if (this.getText() != null) {
            builder.append("text=");
            builder.append(this.getText());
            builder.append(", ");
        }
        builder.append("x=");
        builder.append(this.getX());
        builder.append(", y=");
        builder.append(this.getY());
        builder.append(", width=");
        builder.append(this.getWidth());
        builder.append("]");
        return builder.toString();
    }
}

