/*
 * Decompiled with CFR 0.152.
 */
package com.indvd00m.ascii.render.elements.plot;

import com.indvd00m.ascii.render.api.ICanvas;
import com.indvd00m.ascii.render.api.IContext;
import com.indvd00m.ascii.render.api.IPoint;
import com.indvd00m.ascii.render.api.IRegion;
import com.indvd00m.ascii.render.elements.plot.AbstractPlotObject;
import com.indvd00m.ascii.render.elements.plot.Axis;
import com.indvd00m.ascii.render.elements.plot.AxisLabels;
import com.indvd00m.ascii.render.elements.plot.api.IPlotPoint;
import java.util.List;

public class Plot
extends AbstractPlotObject<Plot> {
    public Plot(List<IPlotPoint> points, IRegion region) {
        super(points, region);
    }

    public IPoint draw(ICanvas canvas, IContext context) {
        Axis axis;
        int width = this.region.getWidth();
        int height = this.region.getHeight();
        int startX = this.region.getX();
        int startY = this.region.getY();
        int lastX = startX + width - 1;
        int lastY = startY + height - 1;
        AxisLabels labels = (AxisLabels)context.lookupTyped(AxisLabels.class, this.getTypedId());
        if (labels != null) {
            startX += labels.getLabelsYWidth();
            width -= labels.getLabelsYWidth();
            --lastY;
            --height;
        }
        if ((axis = (Axis)context.lookupTyped(Axis.class, this.getTypedId())) != null) {
            ++startX;
            --width;
            --lastY;
            --height;
        }
        List<IPlotPoint> normalized = this.plotPoints.normalize(width - 1, height - 1);
        for (IPlotPoint plotPoint : normalized) {
            int x = (int)((double)startX + plotPoint.getX());
            int y = (int)((double)lastY - plotPoint.getY());
            canvas.draw(x, y, "*");
        }
        return this.anchorPoint;
    }
}

