/*
 * Decompiled with CFR 0.152.
 */
package com.indvd00m.ascii.render.elements.plot;

import com.indvd00m.ascii.render.Point;
import com.indvd00m.ascii.render.api.ICanvas;
import com.indvd00m.ascii.render.api.IContext;
import com.indvd00m.ascii.render.api.IPoint;
import com.indvd00m.ascii.render.api.IRegion;
import com.indvd00m.ascii.render.elements.plot.AbstractPlotObject;
import com.indvd00m.ascii.render.elements.plot.api.AxisType;
import com.indvd00m.ascii.render.elements.plot.api.IPlotPoint;
import com.indvd00m.ascii.render.elements.plot.misc.AxisLabel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class AxisLabels
extends AbstractPlotObject<AxisLabels> {
    protected int countX = 5;
    protected int countY = 5;
    protected List<AxisLabel> labels = new ArrayList<AxisLabel>();
    protected int labelsYWidth;
    protected String decimalFractionsLabelsFormat = "%1$,.2f";

    public AxisLabels(List<IPlotPoint> points, IRegion region) {
        super(points, region);
        this.generateLabels();
    }

    public AxisLabels(List<IPlotPoint> points, IRegion region, String decimalFractionsLabelsFormat) {
        super(points, region);
        this.decimalFractionsLabelsFormat = decimalFractionsLabelsFormat;
        this.generateLabels();
    }

    public AxisLabels(List<IPlotPoint> points, IRegion region, int countX, int countY) {
        super(points, region);
        this.countX = countX;
        this.countY = countY;
        this.generateLabels();
    }

    public AxisLabels(List<IPlotPoint> points, IRegion region, int countX, int countY, String decimalFractionsLabelsFormat) {
        super(points, region);
        this.countX = countX;
        this.countY = countY;
        this.decimalFractionsLabelsFormat = decimalFractionsLabelsFormat;
        this.generateLabels();
    }

    public IPoint draw(ICanvas canvas, IContext context) {
        for (AxisLabel label : this.labels) {
            label.draw(canvas, context);
        }
        return this.anchorPoint;
    }

    protected void generateLabels() {
        this.labels.clear();
        List<String> textsX = this.createTexts(AxisType.X, this.plotPoints.getMinX(), this.plotPoints.getDiffX(), this.countX);
        List<String> textsY = this.createTexts(AxisType.Y, this.plotPoints.getMinY(), this.plotPoints.getDiffY(), this.countY);
        this.labelsYWidth = this.getTextsYWidth(textsY);
        int width = this.region.getWidth();
        int height = this.region.getHeight();
        int startX = this.region.getX();
        int startY = this.region.getY();
        int lastX = startX + width - 1;
        int lastY = startY + height - 1;
        LinkedList<String> texts = new LinkedList<String>(textsY);
        String topText = (String)texts.pollLast();
        String bottomText = (String)texts.pollFirst();
        double textsStep = (double)(height - 2) / (double)(texts.size() + 1);
        for (int y = startY; y < lastY; ++y) {
            String text = null;
            if (y == startY) {
                text = topText;
            } else if (y == lastY - 1) {
                text = bottomText;
            } else if ((double)y % textsStep < 1.0) {
                text = (String)texts.pollLast();
            }
            if (text == null) continue;
            text = String.format("%" + this.labelsYWidth + "s", text);
            this.labels.add(new AxisLabel(text, startX, y, AxisType.Y, new Point(startX + this.labelsYWidth, y)));
        }
        texts = new LinkedList<String>(textsX);
        String leftText = (String)texts.pollFirst();
        String rightText = (String)texts.pollLast();
        textsStep = (double)(width - this.labelsYWidth) / (double)(texts.size() + 1);
        String text = (String)texts.pollFirst();
        int num = 0;
        while (text != null) {
            int position = startX + this.labelsYWidth + (int)(textsStep * (double)(++num));
            int start = position - text.length() / 2;
            this.labels.add(new AxisLabel(text, start, lastY, AxisType.X, new Point(position, lastY)));
            text = (String)texts.pollFirst();
        }
        this.labels.add(new AxisLabel(leftText, startX + this.labelsYWidth, lastY, AxisType.X, new Point(startX + this.labelsYWidth, lastY)));
        this.labels.add(new AxisLabel(rightText, lastX - rightText.length() + 1, lastY, AxisType.X, new Point(lastX, lastY)));
    }

    protected List<String> createTexts(AxisType type, double minValue, double diffValues, int count) {
        ArrayList<String> texts = new ArrayList<String>(count);
        double textsStep = diffValues / (double)(count - 1);
        for (int i = 0; i < count; ++i) {
            double value = (double)i * textsStep + minValue;
            String text = this.format(type, value, textsStep);
            texts.add(text);
        }
        return texts;
    }

    protected String format(AxisType type, double value, double labelsStep) {
        String label = null;
        label = labelsStep < 10.0 ? String.format(this.decimalFractionsLabelsFormat, value) : String.format("%,d", (int)value);
        return label;
    }

    protected int getTextsYWidth(List<String> labelsY) {
        int labelsYWidth = 0;
        for (String yLabel : labelsY) {
            int length = yLabel.length();
            if (labelsYWidth >= length) continue;
            labelsYWidth = length;
        }
        return labelsYWidth;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AxisLabels [countX=");
        builder.append(this.countX);
        builder.append(", countY=");
        builder.append(this.countY);
        builder.append(", ");
        if (this.region != null) {
            builder.append("region=");
            builder.append(this.region);
        }
        builder.append("]");
        return builder.toString();
    }

    public List<AxisLabel> getLabels() {
        return Collections.unmodifiableList(this.labels);
    }

    public int getCountX() {
        return this.countX;
    }

    public int getCountY() {
        return this.countY;
    }

    public int getLabelsYWidth() {
        return this.labelsYWidth;
    }
}

