/*
 * Decompiled with CFR 0.152.
 */
package com.indvd00m.ascii.render.elements.plot;

import com.indvd00m.ascii.render.api.ICanvas;
import com.indvd00m.ascii.render.api.IContext;
import com.indvd00m.ascii.render.api.IElement;
import com.indvd00m.ascii.render.api.IPoint;
import com.indvd00m.ascii.render.api.IRegion;
import com.indvd00m.ascii.render.elements.plot.AbstractPlotObject;
import com.indvd00m.ascii.render.elements.plot.AxisLabels;
import com.indvd00m.ascii.render.elements.plot.api.AxisType;
import com.indvd00m.ascii.render.elements.plot.api.IPlotPoint;
import com.indvd00m.ascii.render.elements.plot.misc.AxisLabel;
import java.util.List;

public class Axis
extends AbstractPlotObject<Axis> {
    public Axis(List<IPlotPoint> points, IRegion region) {
        super(points, region);
    }

    public IPoint draw(ICanvas canvas, IContext context) {
        int width = this.region.getWidth();
        int height = this.region.getHeight();
        int startX = this.region.getX();
        int startY = this.region.getY();
        int lastX = startX + width - 1;
        int lastY = startY + height - 1;
        AxisLabels labels = (AxisLabels)context.lookupTyped(AxisLabels.class, this.getTypedId());
        if (labels != null) {
            startX += labels.getLabelsYWidth();
            width -= labels.getLabelsYWidth();
            --lastY;
            --height;
        }
        canvas.draw(startX, startY, "\u2502\n", height);
        canvas.draw(startX + 1, lastY, "\u2500", width - 1);
        canvas.draw(startX, lastY, "\u2514");
        if (labels != null) {
            List<AxisLabel> axisLabels = labels.getLabels();
            for (AxisLabel label : axisLabels) {
                IPoint labelPoint = label.getAnchorPoint();
                IPoint point = context.transform(labelPoint, (IElement)labels, (IElement)this);
                if (label.getAxisType() == AxisType.X) {
                    int x = point.getX();
                    canvas.draw(x, lastY, "\u253c");
                    continue;
                }
                if (label.getAxisType() != AxisType.Y) continue;
                int y = point.getY();
                canvas.draw(startX, y, "\u253c");
            }
        }
        return this.anchorPoint;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Axis [");
        if (this.region != null) {
            builder.append("region=");
            builder.append(this.region);
        }
        builder.append("]");
        return builder.toString();
    }
}

