/*
 * Decompiled with CFR 0.152.
 */
package com.indvd00m.ascii.render.elements.plot;

import com.indvd00m.ascii.render.Point;
import com.indvd00m.ascii.render.api.IElement;
import com.indvd00m.ascii.render.api.IPoint;
import com.indvd00m.ascii.render.api.IRegion;
import com.indvd00m.ascii.render.api.ITypedIdentified;
import com.indvd00m.ascii.render.elements.plot.api.IPlotPoint;
import com.indvd00m.ascii.render.elements.plot.api.IPlotPoints;
import com.indvd00m.ascii.render.elements.plot.misc.PlotPoints;
import java.util.List;

public abstract class AbstractPlotObject<P extends AbstractPlotObject<P>>
implements IElement,
ITypedIdentified<P> {
    protected int typedId;
    protected List<IPlotPoint> points;
    protected IPlotPoints plotPoints;
    protected IRegion region;
    protected IPoint anchorPoint;

    public AbstractPlotObject(List<IPlotPoint> points, IRegion region) {
        this.points = points;
        this.plotPoints = new PlotPoints(points);
        this.region = region;
        this.anchorPoint = new Point(region.getX(), region.getY() + region.getHeight() - 1);
        this.typedId = this.generateTypedId();
    }

    protected int generateTypedId() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.anchorPoint.getX();
        result = 31 * result + this.anchorPoint.getY();
        result = 31 * result + (this.points == null ? 0 : this.points.hashCode());
        return result;
    }

    public List<IPlotPoint> getPoints() {
        return this.points;
    }

    public IRegion getRegion() {
        return this.region;
    }

    public Class<P> getType() {
        return this.getClass();
    }

    public int getTypedId() {
        return this.typedId;
    }
}

