/*
 * Decompiled with CFR 0.152.
 */
package com.indvd00m.ascii.render.elements;

import com.indvd00m.ascii.render.Point;
import com.indvd00m.ascii.render.api.ICanvas;
import com.indvd00m.ascii.render.api.IContext;
import com.indvd00m.ascii.render.api.IElement;
import com.indvd00m.ascii.render.api.IPoint;

public class Text
implements IElement {
    protected String text;
    protected int x;
    protected int y;
    protected int width;
    protected int height;

    public Text(String text) {
        this.text = text;
        this.x = Integer.MIN_VALUE;
        this.y = Integer.MIN_VALUE;
        this.width = Integer.MIN_VALUE;
        this.height = Integer.MIN_VALUE;
    }

    public Text(String text, int x, int y, int width, int height) {
        this.text = text;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public IPoint draw(ICanvas canvas, IContext context) {
        int x = this.x;
        int y = this.y;
        int width = this.width;
        int height = this.height;
        if (x == Integer.MIN_VALUE) {
            x = 0;
        }
        if (y == Integer.MIN_VALUE) {
            y = 0;
        }
        if (width == Integer.MIN_VALUE) {
            width = canvas.getWidth();
        }
        if (height == Integer.MIN_VALUE) {
            height = canvas.getHeight();
        }
        if (height <= 0 || width <= 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(this.text);
        int breaksCount = 0;
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (i - width - breaksCount == breaksCount * width && c != '\n' && c != '\r') {
                c = '\n';
                sb.insert(i, c);
            }
            if (c == '\n' || c == '\r') {
                ++breaksCount;
            }
            if (breaksCount <= height - 1) continue;
            for (int j = i; j >= 0; --j) {
                char prevC = sb.charAt(j);
                if (prevC == '\n' || prevC == '\r') continue;
                sb.setCharAt(j, '\u2026');
                break;
            }
            sb.setLength(i + 1);
            break;
        }
        canvas.draw(x, y, sb.toString());
        return new Point(x, y);
    }

    public String getText() {
        return this.text;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.height;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        result = 31 * result + this.width;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Text other = (Text)obj;
        if (this.height != other.height) {
            return false;
        }
        if (this.text == null ? other.text != null : !this.text.equals(other.text)) {
            return false;
        }
        if (this.width != other.width) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Text [");
        if (this.text != null) {
            builder.append("text=");
            builder.append(this.text);
            builder.append(", ");
        }
        builder.append("x=");
        builder.append(this.x);
        builder.append(", y=");
        builder.append(this.y);
        builder.append(", width=");
        builder.append(this.width);
        builder.append(", height=");
        builder.append(this.height);
        builder.append("]");
        return builder.toString();
    }
}

