/*
 * Decompiled with CFR 0.152.
 */
package com.indvd00m.ascii.render.elements;

import com.indvd00m.ascii.render.Canvas;
import com.indvd00m.ascii.render.Point;
import com.indvd00m.ascii.render.api.ICanvas;
import com.indvd00m.ascii.render.api.IContext;
import com.indvd00m.ascii.render.api.IElement;
import com.indvd00m.ascii.render.api.IPoint;
import com.indvd00m.ascii.render.elements.table.CellPosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;

public class Table
implements IElement {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected int columns;
    protected int rows;
    protected List<IElement> elements;
    protected List<Boolean> highlights;

    public Table(int columns, int rows) {
        this(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, columns, rows);
    }

    public Table(int x, int y, int width, int height, int columns, int rows) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.columns = columns > 0 ? columns : 1;
        this.rows = rows > 0 ? rows : 1;
        int size = rows * columns;
        this.elements = new ArrayList<IElement>(size);
        this.highlights = new ArrayList<Boolean>(size);
        for (int i = 0; i < size; ++i) {
            this.elements.add(null);
            this.highlights.add(Boolean.FALSE);
        }
    }

    public IElement setElement(int column, int row, IElement element) {
        return this.setElement(column, row, element, false);
    }

    public IElement setElement(int column, int row, IElement element, boolean highlight) {
        int index = this.coordToIndex(column, row);
        this.highlights.set(index, highlight);
        return this.elements.set(index, element);
    }

    public IElement getElement(int column, int row) {
        int index = this.coordToIndex(column, row);
        return this.elements.get(index);
    }

    public boolean isHighlighted(int column, int row) {
        int index = this.coordToIndex(column, row);
        if (index < 0 || index >= this.highlights.size()) {
            return false;
        }
        return this.highlights.get(index);
    }

    public boolean setHighlighted(int column, int row, boolean highlight) {
        int index = this.coordToIndex(column, row);
        return this.highlights.set(index, highlight);
    }

    protected int coordToIndex(int x, int y) {
        if (x <= 0 || y <= 0) {
            return -1;
        }
        if (x > this.columns) {
            return -1;
        }
        return (y - 1) * this.columns + (x - 1);
    }

    protected Point indexToCoord(int i) {
        int x = i % this.columns + 1;
        int y = i / this.columns + 1;
        return new Point(x, y);
    }

    public IPoint draw(ICanvas canvas, IContext context) {
        int x = this.x;
        int y = this.y;
        int width = this.width;
        int height = this.height;
        if (x == Integer.MIN_VALUE) {
            x = 0;
        }
        if (y == Integer.MIN_VALUE) {
            y = 0;
        }
        if (width == Integer.MIN_VALUE) {
            width = canvas.getWidth();
        }
        if (height == Integer.MIN_VALUE) {
            height = canvas.getHeight();
        }
        for (int r = 0; r <= this.rows; ++r) {
            int cellHeight;
            int cellY;
            if (r == this.rows) {
                cellY = y + height - 1;
                cellHeight = 0;
            } else if (this.rows >= height) {
                cellY = y + r;
                cellHeight = 1;
            } else {
                cellY = y + r * height / this.rows;
                cellHeight = y + (r + 1) * height / this.rows - cellY;
            }
            for (int c = 0; c <= this.columns; ++c) {
                int cellWidth;
                int cellX;
                if (c == this.columns) {
                    cellX = x + width - 1;
                    cellWidth = 0;
                } else if (this.columns >= width) {
                    cellX = x + c;
                    cellWidth = 1;
                } else {
                    cellX = x + c * width / this.columns;
                    cellWidth = x + (c + 1) * width / this.columns - cellX;
                }
                EnumSet<CellPosition> highlights = this.getHighlightedNeighborCells(c + 1, r + 1);
                this.drawBorders(canvas, cellY, cellHeight, cellX, cellWidth, highlights);
                this.drawCellCorners(canvas, r, cellY, c, cellX, highlights);
                this.drawTableCorners(canvas, r, cellY, c, cellX, highlights);
                this.drawBorderCellCorners(canvas, r, cellY, cellHeight, c, cellX, cellWidth, highlights);
            }
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            IElement element = this.elements.get(i);
            if (element == null) continue;
            Point coord = this.indexToCoord(i);
            int startX = x + (coord.getX() - 1) * width / this.columns + 1;
            int startY = y + (coord.getY() - 1) * height / this.rows + 1;
            int endX = x + coord.getX() * width / this.columns;
            int endY = y + coord.getY() * height / this.rows;
            if (endX == x + width) {
                --endX;
            }
            if (endY == y + height) {
                --endY;
            }
            int cellWidth = endX - startX;
            int cellHeight = endY - startY;
            Canvas elementCanvas = new Canvas(cellWidth, cellHeight);
            element.draw((ICanvas)elementCanvas, context);
            canvas.draw(startX, startY, elementCanvas.getText());
        }
        return new Point(x, y);
    }

    private void drawBorderCellCorners(ICanvas canvas, int r, int cellY, int cellHeight, int c, int cellX, int cellWidth, EnumSet<CellPosition> highlights) {
        if (r != 0 && r != this.rows) {
            if (c == 0) {
                if (this.containsNone((Collection)highlights, (Object)((Object)CellPosition.Up), (Object)((Object)CellPosition.Center))) {
                    canvas.draw(cellX, cellY, "\u251c");
                }
                if (this.containsAll(highlights, CellPosition.Up) && this.containsNone(highlights, CellPosition.Center)) {
                    canvas.draw(cellX, cellY, "\u2521");
                }
                if (this.containsAll(highlights, CellPosition.Center) && this.containsNone(highlights, CellPosition.Up)) {
                    canvas.draw(cellX, cellY, "\u2522");
                }
                if (this.containsAll((Collection)highlights, (Object)((Object)CellPosition.Up), (Object)((Object)CellPosition.Center))) {
                    canvas.draw(cellX, cellY, "\u2523");
                }
            }
            if (c == this.columns) {
                if (this.containsNone((Collection)highlights, (Object)((Object)CellPosition.Left), (Object)((Object)CellPosition.UpLeft))) {
                    canvas.draw(cellX + cellWidth, cellY, "\u2524");
                }
                if (this.containsAll(highlights, CellPosition.UpLeft) && this.containsNone(highlights, CellPosition.Left)) {
                    canvas.draw(cellX + cellWidth, cellY, "\u2529");
                }
                if (this.containsAll(highlights, CellPosition.Left) && this.containsNone(highlights, CellPosition.UpLeft)) {
                    canvas.draw(cellX + cellWidth, cellY, "\u252a");
                }
                if (this.containsAll((Collection)highlights, (Object)((Object)CellPosition.Left), (Object)((Object)CellPosition.UpLeft))) {
                    canvas.draw(cellX + cellWidth, cellY, "\u252b");
                }
            }
        }
        if (c != 0 && c != this.columns) {
            if (r == 0) {
                if (this.containsNone((Collection)highlights, (Object)((Object)CellPosition.Center), (Object)((Object)CellPosition.Left))) {
                    canvas.draw(cellX, cellY, "\u252c");
                }
                if (this.containsAll(highlights, CellPosition.Left) && this.containsNone(highlights, CellPosition.Center)) {
                    canvas.draw(cellX, cellY, "\u2531");
                }
                if (this.containsAll(highlights, CellPosition.Center) && this.containsNone(highlights, CellPosition.Left)) {
                    canvas.draw(cellX, cellY, "\u2532");
                }
                if (this.containsAll((Collection)highlights, (Object)((Object)CellPosition.Center), (Object)((Object)CellPosition.Left))) {
                    canvas.draw(cellX, cellY, "\u2533");
                }
            }
            if (r == this.rows) {
                if (this.containsNone((Collection)highlights, (Object)((Object)CellPosition.Up), (Object)((Object)CellPosition.UpLeft))) {
                    canvas.draw(cellX, cellY + cellHeight, "\u2534");
                }
                if (this.containsAll(highlights, CellPosition.UpLeft) && this.containsNone(highlights, CellPosition.Up)) {
                    canvas.draw(cellX, cellY + cellHeight, "\u2539");
                }
                if (this.containsAll(highlights, CellPosition.Up) && this.containsNone(highlights, CellPosition.UpLeft)) {
                    canvas.draw(cellX, cellY + cellHeight, "\u253a");
                }
                if (this.containsAll((Collection)highlights, (Object)((Object)CellPosition.Up), (Object)((Object)CellPosition.UpLeft))) {
                    canvas.draw(cellX, cellY + cellHeight, "\u253b");
                }
            }
        }
    }

    private void drawTableCorners(ICanvas canvas, int r, int cellY, int c, int cellX, EnumSet<CellPosition> highlights) {
        if (c == 0 && r == 0) {
            if (this.containsAll(highlights, CellPosition.Center)) {
                canvas.draw(cellX, cellY, "\u250f");
            } else {
                canvas.draw(cellX, cellY, "\u250c");
            }
        } else if (c == this.columns && r == 0) {
            if (this.containsAll(highlights, CellPosition.Left)) {
                canvas.draw(cellX, cellY, "\u2513");
            } else {
                canvas.draw(cellX, cellY, "\u2510");
            }
        } else if (c == 0 && r == this.rows) {
            if (this.containsAll(highlights, CellPosition.Up)) {
                canvas.draw(cellX, cellY, "\u2517");
            } else {
                canvas.draw(cellX, cellY, "\u2514");
            }
        } else if (c == this.columns && r == this.rows) {
            if (this.containsAll(highlights, CellPosition.UpLeft)) {
                canvas.draw(cellX, cellY, "\u251b");
            } else {
                canvas.draw(cellX, cellY, "\u2518");
            }
        }
    }

    private void drawCellCorners(ICanvas canvas, int r, int cellY, int c, int cellX, EnumSet<CellPosition> highlights) {
        if (r > 0 && r < this.rows && c > 0 && c < this.columns) {
            if (this.containsNone((Collection)highlights, (Object)((Object)CellPosition.Up), (Object)((Object)CellPosition.Center), (Object)((Object)CellPosition.Left), (Object)((Object)CellPosition.UpLeft))) {
                canvas.draw(cellX, cellY, "\u253c");
            }
            if (this.containsAny(highlights, CellPosition.UpLeft) && this.containsNone((Collection)highlights, (Object)((Object)CellPosition.Up), (Object)((Object)CellPosition.Center), (Object)((Object)CellPosition.Left))) {
                canvas.draw(cellX, cellY, "\u2543");
            }
            if (this.containsAny(highlights, CellPosition.Up) && this.containsNone((Collection)highlights, (Object)((Object)CellPosition.Center), (Object)((Object)CellPosition.Left), (Object)((Object)CellPosition.UpLeft))) {
                canvas.draw(cellX, cellY, "\u2544");
            }
            if (this.containsAny(highlights, CellPosition.Center) && this.containsNone((Collection)highlights, (Object)((Object)CellPosition.Left), (Object)((Object)CellPosition.UpLeft), (Object)((Object)CellPosition.Up))) {
                canvas.draw(cellX, cellY, "\u2546");
            }
            if (this.containsAny(highlights, CellPosition.Left) && this.containsNone((Collection)highlights, (Object)((Object)CellPosition.UpLeft), (Object)((Object)CellPosition.Up), (Object)((Object)CellPosition.Center))) {
                canvas.draw(cellX, cellY, "\u2545");
            }
            if (this.containsAll((Collection)highlights, (Object)((Object)CellPosition.UpLeft), (Object)((Object)CellPosition.Up)) && this.containsNone((Collection)highlights, (Object)((Object)CellPosition.Center), (Object)((Object)CellPosition.Left))) {
                canvas.draw(cellX, cellY, "\u2547");
            }
            if (this.containsAll((Collection)highlights, (Object)((Object)CellPosition.Up), (Object)((Object)CellPosition.Center)) && this.containsNone((Collection)highlights, (Object)((Object)CellPosition.Left), (Object)((Object)CellPosition.UpLeft))) {
                canvas.draw(cellX, cellY, "\u254a");
            }
            if (this.containsAll((Collection)highlights, (Object)((Object)CellPosition.Center), (Object)((Object)CellPosition.Left)) && this.containsNone((Collection)highlights, (Object)((Object)CellPosition.UpLeft), (Object)((Object)CellPosition.Up))) {
                canvas.draw(cellX, cellY, "\u2548");
            }
            if (this.containsAll((Collection)highlights, (Object)((Object)CellPosition.Left), (Object)((Object)CellPosition.UpLeft)) && this.containsNone((Collection)highlights, (Object)((Object)CellPosition.Up), (Object)((Object)CellPosition.Center))) {
                canvas.draw(cellX, cellY, "\u2549");
            }
            if (this.containsAll((Collection)highlights, (Object)((Object)CellPosition.Up), (Object)((Object)CellPosition.Center), (Object)((Object)CellPosition.Left))) {
                canvas.draw(cellX, cellY, "\u254b");
            }
            if (this.containsAll((Collection)highlights, (Object)((Object)CellPosition.Center), (Object)((Object)CellPosition.Left), (Object)((Object)CellPosition.UpLeft))) {
                canvas.draw(cellX, cellY, "\u254b");
            }
            if (this.containsAll((Collection)highlights, (Object)((Object)CellPosition.Left), (Object)((Object)CellPosition.UpLeft), (Object)((Object)CellPosition.Up))) {
                canvas.draw(cellX, cellY, "\u254b");
            }
            if (this.containsAll((Collection)highlights, (Object)((Object)CellPosition.UpLeft), (Object)((Object)CellPosition.Up), (Object)((Object)CellPosition.Center))) {
                canvas.draw(cellX, cellY, "\u254b");
            }
        }
    }

    private void drawBorders(ICanvas canvas, int cellY, int cellHeight, int cellX, int cellWidth, EnumSet<CellPosition> highlights) {
        if (this.containsAny((Collection)highlights, (Object)((Object)CellPosition.Center), (Object)((Object)CellPosition.Up))) {
            canvas.draw(cellX + 1, cellY, "\u2501", cellWidth - 1);
        } else {
            canvas.draw(cellX + 1, cellY, "\u2500", cellWidth - 1);
        }
        if (this.containsAny((Collection)highlights, (Object)((Object)CellPosition.Center), (Object)((Object)CellPosition.Left))) {
            canvas.draw(cellX, cellY + 1, "\u2503\n", cellHeight - 1);
        } else {
            canvas.draw(cellX, cellY + 1, "\u2502\n", cellHeight - 1);
        }
    }

    protected <T> boolean containsAll(Collection<T> collection, T ... values) {
        for (T value : values) {
            if (collection.contains(value)) continue;
            return false;
        }
        return true;
    }

    protected <T> boolean containsAny(Collection<T> collection, T ... values) {
        for (T value : values) {
            if (!collection.contains(value)) continue;
            return true;
        }
        return false;
    }

    protected <T> boolean containsNone(Collection<T> collection, T ... values) {
        return !this.containsAny(collection, values);
    }

    protected EnumSet<CellPosition> getHighlightedNeighborCells(int column, int row) {
        EnumSet<CellPosition> positions = EnumSet.noneOf(CellPosition.class);
        if (this.isHighlighted(column, row)) {
            positions.add(CellPosition.Center);
        }
        if (this.isHighlighted(column, row - 1)) {
            positions.add(CellPosition.Up);
        }
        if (this.isHighlighted(column + 1, row - 1)) {
            positions.add(CellPosition.UpRight);
        }
        if (this.isHighlighted(column + 1, row)) {
            positions.add(CellPosition.Right);
        }
        if (this.isHighlighted(column + 1, row + 1)) {
            positions.add(CellPosition.DownRight);
        }
        if (this.isHighlighted(column, row + 1)) {
            positions.add(CellPosition.Down);
        }
        if (this.isHighlighted(column - 1, row + 1)) {
            positions.add(CellPosition.DownLeft);
        }
        if (this.isHighlighted(column - 1, row)) {
            positions.add(CellPosition.Left);
        }
        if (this.isHighlighted(column - 1, row - 1)) {
            positions.add(CellPosition.UpLeft);
        }
        return positions;
    }

    public String toString() {
        return "Table [x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ", columns=" + this.columns + ", rows=" + this.rows + ", elements=" + this.elements + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Table table = (Table)o;
        if (this.x != table.x) {
            return false;
        }
        if (this.y != table.y) {
            return false;
        }
        if (this.width != table.width) {
            return false;
        }
        if (this.height != table.height) {
            return false;
        }
        if (this.columns != table.columns) {
            return false;
        }
        if (this.rows != table.rows) {
            return false;
        }
        if (!this.elements.equals(table.elements)) {
            return false;
        }
        return this.highlights.equals(table.highlights);
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        result = 31 * result + this.columns;
        result = 31 * result + this.rows;
        result = 31 * result + this.elements.hashCode();
        result = 31 * result + this.highlights.hashCode();
        return result;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }
}

