/*
 * Decompiled with CFR 0.152.
 */
package com.indvd00m.ascii.render.elements;

import com.indvd00m.ascii.render.Point;
import com.indvd00m.ascii.render.api.ICanvas;
import com.indvd00m.ascii.render.api.IContext;
import com.indvd00m.ascii.render.api.IElement;
import com.indvd00m.ascii.render.api.IPoint;

public class Rectangle
implements IElement {
    protected int x;
    protected int y;
    protected int width;
    protected int height;

    public Rectangle() {
        this.x = Integer.MIN_VALUE;
        this.y = Integer.MIN_VALUE;
        this.width = Integer.MIN_VALUE;
        this.height = Integer.MIN_VALUE;
    }

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public IPoint draw(ICanvas canvas, IContext context) {
        int x = this.x;
        int y = this.y;
        int width = this.width;
        int height = this.height;
        if (x == Integer.MIN_VALUE) {
            x = 0;
        }
        if (y == Integer.MIN_VALUE) {
            y = 0;
        }
        if (width == Integer.MIN_VALUE) {
            width = canvas.getWidth();
        }
        if (height == Integer.MIN_VALUE) {
            height = canvas.getHeight();
        }
        canvas.draw(x, y, "\u2500", width);
        canvas.draw(x, y + height - 1, "\u2500", width);
        canvas.draw(x, y, "\u2502\n", height);
        canvas.draw(x + width - 1, y, "\u2502\n", height);
        canvas.draw(x, y, "\u250c");
        canvas.draw(x + width - 1, y, "\u2510");
        canvas.draw(x, y + height - 1, "\u2514");
        canvas.draw(x + width - 1, y + height - 1, "\u2518");
        return new Point(x, y);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Rectangle [x=");
        builder.append(this.x);
        builder.append(", y=");
        builder.append(this.y);
        builder.append(", width=");
        builder.append(this.width);
        builder.append(", height=");
        builder.append(this.height);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.height;
        result = 31 * result + this.width;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rectangle other = (Rectangle)obj;
        if (this.height != other.height) {
            return false;
        }
        if (this.width != other.width) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

