/*
 * Decompiled with CFR 0.152.
 */
package com.indvd00m.ascii.render.elements;

import com.indvd00m.ascii.render.Point;
import com.indvd00m.ascii.render.api.ICanvas;
import com.indvd00m.ascii.render.api.IContext;
import com.indvd00m.ascii.render.api.IElement;
import com.indvd00m.ascii.render.api.IPoint;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class PseudoText
implements IElement {
    protected String text;
    protected int x;
    protected int y;
    protected int height;
    protected boolean antialising = true;
    protected Font font;

    public PseudoText(String text) {
        this.text = text;
        this.x = Integer.MIN_VALUE;
        this.y = Integer.MIN_VALUE;
        this.height = Integer.MIN_VALUE;
    }

    public PseudoText(String text, boolean antialising) {
        this.text = text;
        this.x = Integer.MIN_VALUE;
        this.y = Integer.MIN_VALUE;
        this.height = Integer.MIN_VALUE;
        this.antialising = antialising;
    }

    public PseudoText(String text, Font font, boolean antialising) {
        this.text = text;
        this.x = Integer.MIN_VALUE;
        this.y = Integer.MIN_VALUE;
        this.height = Integer.MIN_VALUE;
        this.font = font;
        this.antialising = antialising;
    }

    public PseudoText(String text, int x, int y, int height) {
        this.text = text;
        this.x = x;
        this.y = y;
        this.height = height;
    }

    public PseudoText(String text, int x, int y, int height, boolean antialising) {
        this.text = text;
        this.x = x;
        this.y = y;
        this.height = height;
        this.antialising = antialising;
    }

    public PseudoText(String text, int x, int y, int height, Font font, boolean antialising) {
        this.text = text;
        this.x = x;
        this.y = y;
        this.height = height;
        this.font = font;
        this.antialising = antialising;
    }

    public IPoint draw(ICanvas canvas, IContext context) {
        int x = this.x;
        int y = this.y;
        int height = this.height;
        if (x == Integer.MIN_VALUE) {
            x = 0;
        }
        if (y == Integer.MIN_VALUE) {
            y = 0;
        }
        if (height == Integer.MIN_VALUE) {
            height = canvas.getHeight();
        }
        if (height <= 0) {
            return null;
        }
        int width = canvas.getWidth() - x;
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D graphics = image.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        if (this.antialising) {
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        Font font = this.getFont().deriveFont(24);
        FontMetrics fm = graphics.getFontMetrics(font);
        Rectangle2D r2d = fm.getStringBounds(this.text, graphics);
        float leadingFactor = (float)fm.getLeading() / (float)fm.getHeight();
        float size = (float)((double)(font.getSize2D() * (float)height) / (r2d.getHeight() - r2d.getHeight() * (double)leadingFactor));
        font = font.deriveFont(size);
        fm = graphics.getFontMetrics(font);
        int ascent = fm.getAscent();
        int leading = fm.getLeading();
        Color fontColor = Color.BLACK;
        Color backgroundColor = Color.WHITE;
        graphics.setFont(font);
        graphics.setColor(backgroundColor);
        graphics.fillRect(0, 0, width, height);
        graphics.setColor(fontColor);
        graphics.drawString(this.text, 0, ascent + leading);
        for (int imgX = 0; imgX < width; ++imgX) {
            for (int imgY = 0; imgY < height; ++imgY) {
                int rgb = image.getRGB(imgX, imgY);
                Color color = new Color(rgb);
                if (backgroundColor.equals(color)) continue;
                int cx = imgX + x;
                int cy = imgY + y;
                char c = this.colorToChar(fontColor, backgroundColor, color);
                canvas.draw(cx, cy, c);
            }
        }
        return new Point(x, y);
    }

    protected char colorToChar(Color fontColor, Color backgroundColor, Color pixelColor) {
        if (backgroundColor.equals(pixelColor)) {
            return ' ';
        }
        if (this.antialising) {
            double diff = this.getColorDistancePercentage(fontColor, pixelColor, backgroundColor);
            if (diff > 75.0) {
                return '\u2591';
            }
            if (diff > 50.0) {
                return '\u2592';
            }
            if (diff > 25.0) {
                return '\u2593';
            }
            return '\u2588';
        }
        return '\u2588';
    }

    protected double getColorDistancePercentage(Color sourceColor, Color targetColor, Color maxDistanceColor) {
        double maxDistance = this.getColorDistance(sourceColor, maxDistanceColor);
        double distance = this.getColorDistance(sourceColor, targetColor);
        double diff = distance / maxDistance;
        return diff * 100.0;
    }

    protected double getColorDistance(Color c1, Color c2) {
        double rmean = (c1.getRed() + c2.getRed()) / 2;
        int r = c1.getRed() - c2.getRed();
        int g = c1.getGreen() - c2.getGreen();
        int b = c1.getBlue() - c2.getBlue();
        double weightR = 2.0 + rmean / 256.0;
        double weightG = 4.0;
        double weightB = 2.0 + (255.0 - rmean) / 256.0;
        return Math.sqrt(weightR * (double)r * (double)r + weightG * (double)g * (double)g + weightB * (double)b * (double)b);
    }

    protected Font createFont() {
        InputStream is = null;
        try {
            Font font;
            is = this.getClass().getResourceAsStream("/fonts/DejaVuSansMono/DejaVuSansMono.ttf");
            Font font2 = font = Font.createFont(0, is);
            return font2;
        }
        catch (FontFormatException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected void writeImageToPNG(BufferedImage image, String path) {
        try {
            ImageIO.write((RenderedImage)image, "png", new File(path));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getText() {
        return this.text;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getHeight() {
        return this.height;
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = this.createFont();
        }
        return this.font;
    }

    public boolean isAntialising() {
        return this.antialising;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.antialising ? 1231 : 1237);
        result = 31 * result + (this.font == null ? 0 : this.font.hashCode());
        result = 31 * result + this.height;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PseudoText other = (PseudoText)obj;
        if (this.antialising != other.antialising) {
            return false;
        }
        if (this.font == null ? other.font != null : !this.font.equals(other.font)) {
            return false;
        }
        if (this.height != other.height) {
            return false;
        }
        if (this.text == null ? other.text != null : !this.text.equals(other.text)) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PseudoText [");
        if (this.text != null) {
            builder.append("text=");
            builder.append(this.text);
            builder.append(", ");
        }
        builder.append("x=");
        builder.append(this.x);
        builder.append(", y=");
        builder.append(this.y);
        builder.append(", height=");
        builder.append(this.height);
        builder.append(", antialising=");
        builder.append(this.antialising);
        builder.append(", ");
        if (this.font != null) {
            builder.append("font=");
            builder.append(this.font);
        }
        builder.append("]");
        return builder.toString();
    }
}

