/*
 * Decompiled with CFR 0.152.
 */
package com.indvd00m.ascii.render.elements;

import com.indvd00m.ascii.render.Point;
import com.indvd00m.ascii.render.Region;
import com.indvd00m.ascii.render.api.ICanvas;
import com.indvd00m.ascii.render.api.IContext;
import com.indvd00m.ascii.render.api.IElement;
import com.indvd00m.ascii.render.api.IPoint;
import com.indvd00m.ascii.render.api.IRegion;

public class Overlay
implements IElement {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected ICanvas overlay;
    protected boolean opacity;

    public Overlay(ICanvas overlay) {
        this(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, overlay, false);
    }

    public Overlay(ICanvas overlay, boolean opacity) {
        this(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, overlay, opacity);
    }

    public Overlay(int x, int y, ICanvas overlay) {
        this(x, y, Integer.MIN_VALUE, Integer.MIN_VALUE, overlay, false);
    }

    public Overlay(int x, int y, ICanvas overlay, boolean opacity) {
        this(x, y, Integer.MIN_VALUE, Integer.MIN_VALUE, overlay, opacity);
    }

    public Overlay(int x, int y, int width, int height, ICanvas overlay) {
        this(x, y, width, height, overlay, false);
    }

    public Overlay(int x, int y, int width, int height, ICanvas overlay, boolean opacity) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.overlay = overlay;
        this.opacity = opacity;
    }

    public IPoint draw(ICanvas canvas, IContext context) {
        int x = this.x;
        int y = this.y;
        int width = this.width;
        int height = this.height;
        if (x == Integer.MIN_VALUE) {
            x = 0;
        }
        if (y == Integer.MIN_VALUE) {
            y = 0;
        }
        if (width == Integer.MIN_VALUE) {
            width = this.overlay.getWidth();
        }
        if (height == Integer.MIN_VALUE) {
            height = this.overlay.getHeight();
        }
        Region region = new Region(x, y, width, height);
        this.drawOver(canvas, this.overlay, region);
        return new Point(x, y);
    }

    protected void drawOver(ICanvas c1, ICanvas c2, IRegion region) {
        for (int c1x = region.getX(); c1x < region.getX() + region.getWidth(); ++c1x) {
            for (int c1y = region.getY(); c1y < region.getY() + region.getHeight(); ++c1y) {
                int c2x = c1x - region.getX();
                int c2y = c1y - region.getY();
                if (!this.opacity && !c2.isCharDrawed(c2x, c2y)) continue;
                char c = c2.getChar(c2x, c2y);
                c1.draw(c1x, c1y, c);
            }
        }
    }

    public String toString() {
        return "Overlay [x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ", overlay=" + this.overlay.getText().hashCode() + ", opacity=" + this.opacity + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.overlay == null ? 0 : this.overlay.hashCode());
        result = 31 * result + this.height;
        result = 31 * result + (this.opacity ? 1231 : 1237);
        result = 31 * result + this.width;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Overlay other = (Overlay)obj;
        if (this.overlay == null ? other.overlay != null : !this.overlay.equals(other.overlay)) {
            return false;
        }
        if (this.height != other.height) {
            return false;
        }
        if (this.opacity != other.opacity) {
            return false;
        }
        if (this.width != other.width) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ICanvas getOverlay() {
        return this.overlay;
    }

    public boolean isOpacity() {
        return this.opacity;
    }
}

