/*
 * Decompiled with CFR 0.152.
 */
package com.indvd00m.ascii.render.elements;

import com.indvd00m.ascii.render.Point;
import com.indvd00m.ascii.render.api.ICanvas;
import com.indvd00m.ascii.render.api.IContext;
import com.indvd00m.ascii.render.api.IElement;
import com.indvd00m.ascii.render.api.IPoint;
import java.util.ArrayList;

public class Line
implements IElement {
    protected IPoint start;
    protected IPoint end;
    protected char pen = (char)9679;

    public Line(IPoint start, IPoint end) {
        this.start = start;
        this.end = end;
    }

    public Line(IPoint start, IPoint end, char pen) {
        this.start = start;
        this.end = end;
        this.pen = pen;
    }

    /*
     * WARNING - void declaration
     */
    public IPoint draw(ICanvas canvas, IContext context) {
        int x1 = this.start.getX();
        int x2 = this.end.getX();
        int y1 = this.start.getY();
        int y2 = this.end.getY();
        ArrayList<Point> points = new ArrayList<Point>();
        int w = x2 - x1;
        int h = y2 - y1;
        int dx1 = 0;
        int dy1 = 0;
        int dx2 = 0;
        int dy2 = 0;
        if (w < 0) {
            dx1 = -1;
        } else if (w > 0) {
            dx1 = 1;
        }
        if (h < 0) {
            dy1 = -1;
        } else if (h > 0) {
            dy1 = 1;
        }
        if (w < 0) {
            dx2 = -1;
        } else if (w > 0) {
            dx2 = 1;
        }
        int longest = Math.abs(w);
        int shortest = Math.abs(h);
        if (longest <= shortest) {
            longest = Math.abs(h);
            shortest = Math.abs(w);
            if (h < 0) {
                dy2 = -1;
            } else if (h > 0) {
                dy2 = 1;
            }
            dx2 = 0;
        }
        int numerator = longest >> 1;
        int n = x1;
        int y = y1;
        for (int i = 0; i <= longest; ++i) {
            void var18_20;
            points.add(new Point((int)var18_20, y));
            if ((numerator += shortest) >= longest) {
                numerator -= longest;
                var18_20 += dx1;
                y += dy1;
                continue;
            }
            var18_20 += dx2;
            y += dy2;
        }
        for (IPoint iPoint : points) {
            canvas.draw(iPoint.getX(), iPoint.getY(), this.pen);
        }
        return this.start;
    }

    protected int compare(double d1, double d2, double precision) {
        double diff = d1 - d2;
        if (Math.abs(diff) < precision) {
            return 0;
        }
        if (diff < 0.0) {
            return -1;
        }
        return 1;
    }

    public IPoint getStart() {
        return this.start;
    }

    public IPoint getEnd() {
        return this.end;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Line other = (Line)obj;
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        return !(this.start == null ? other.start != null : !this.start.equals(other.start));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Line [");
        if (this.start != null) {
            builder.append("start=");
            builder.append(this.start);
            builder.append(", ");
        }
        if (this.end != null) {
            builder.append("end=");
            builder.append(this.end);
        }
        builder.append("]");
        return builder.toString();
    }

    public char getPen() {
        return this.pen;
    }
}

