/*
 * Decompiled with CFR 0.152.
 */
package com.indvd00m.ascii.render.elements;

import com.indvd00m.ascii.render.Point;
import com.indvd00m.ascii.render.api.ICanvas;
import com.indvd00m.ascii.render.api.IContext;
import com.indvd00m.ascii.render.api.IElement;
import com.indvd00m.ascii.render.api.IPoint;

public class Label
implements IElement {
    protected String text;
    protected int x;
    protected int y;
    protected int width;

    public Label(String text) {
        this.text = text;
        this.x = Integer.MIN_VALUE;
        this.y = Integer.MIN_VALUE;
        this.width = Integer.MIN_VALUE;
    }

    public Label(String text, int x, int y) {
        this.text = text;
        this.x = x;
        this.y = y;
        this.width = Integer.MIN_VALUE;
    }

    public Label(String text, int x, int y, int width) {
        this.text = text;
        this.x = x;
        this.y = y;
        this.width = width;
    }

    public IPoint draw(ICanvas canvas, IContext context) {
        int x = this.x;
        int y = this.y;
        int width = this.width;
        String s = this.text.replaceAll("[\\n\\r]+", " ");
        if (x == Integer.MIN_VALUE) {
            x = 0;
        }
        if (y == Integer.MIN_VALUE) {
            y = 0;
        }
        if (width == Integer.MIN_VALUE) {
            width = s.length();
        }
        if (s.length() > width) {
            if (width > 1) {
                s = s.substring(0, width);
                s = s.replaceAll(".$", "\u2026");
            } else {
                s = "";
            }
        }
        canvas.draw(x, y, s);
        return new Point(x, y);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        result = 31 * result + this.width;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Label other = (Label)obj;
        if (this.text == null ? other.text != null : !this.text.equals(other.text)) {
            return false;
        }
        if (this.width != other.width) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    public String getText() {
        return this.text;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Label [");
        if (this.text != null) {
            builder.append("text=");
            builder.append(this.text);
            builder.append(", ");
        }
        builder.append("x=");
        builder.append(this.x);
        builder.append(", y=");
        builder.append(this.y);
        builder.append(", width=");
        builder.append(this.width);
        builder.append("]");
        return builder.toString();
    }
}

