/*
 * Decompiled with CFR 0.152.
 */
package com.indvd00m.ascii.render.elements;

import com.indvd00m.ascii.render.Point;
import com.indvd00m.ascii.render.api.ICanvas;
import com.indvd00m.ascii.render.api.IContext;
import com.indvd00m.ascii.render.api.IElement;
import com.indvd00m.ascii.render.api.IPoint;

public class Ellipse
implements IElement {
    protected int x;
    protected int y;
    protected int width;
    protected int height;

    public Ellipse() {
        this.x = Integer.MIN_VALUE;
        this.y = Integer.MIN_VALUE;
        this.width = Integer.MIN_VALUE;
        this.height = Integer.MIN_VALUE;
    }

    public Ellipse(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public IPoint draw(ICanvas canvas, IContext context) {
        int x = this.x;
        int y = this.y;
        int width = this.width;
        int height = this.height;
        if (x == Integer.MIN_VALUE) {
            x = canvas.getWidth() / 2;
        }
        if (y == Integer.MIN_VALUE) {
            y = canvas.getHeight() / 2;
        }
        if (width == Integer.MIN_VALUE) {
            width = canvas.getWidth() - 1;
        }
        if (height == Integer.MIN_VALUE) {
            height = canvas.getHeight() - 1;
        }
        double a = (double)width / 2.0;
        double b = (double)height / 2.0;
        double c = Math.sqrt(Math.abs(Math.pow(a, 2.0) - Math.pow(b, 2.0)));
        double f1x = (double)x - c;
        double f1y = y;
        double f2x = (double)x + c;
        double f2y = y;
        int x1 = (int)((double)x - a);
        while ((double)x1 <= (double)x + a) {
            int y1 = (int)((double)y - b);
            while ((double)y1 <= (double)y + b) {
                double d2;
                double d1 = Math.sqrt(Math.pow(f1x - (double)x1, 2.0) + Math.pow(f1y - (double)y1, 2.0));
                if (this.compare(d1 + (d2 = Math.sqrt(Math.pow(f2x - (double)x1, 2.0) + Math.pow(f2y - (double)y1, 2.0))), 2.0 * a, 0.5) == 0) {
                    canvas.draw(x1, y1, "*");
                }
                ++y1;
            }
            ++x1;
        }
        return new Point(x, y);
    }

    protected int compare(double d1, double d2, double precision) {
        double diff = d1 - d2;
        if (Math.abs(diff) < precision) {
            return 0;
        }
        if (diff < 0.0) {
            return -1;
        }
        return 1;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.height;
        result = 31 * result + this.width;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Ellipse other = (Ellipse)obj;
        if (this.height != other.height) {
            return false;
        }
        if (this.width != other.width) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Ellipse [x=");
        builder.append(this.x);
        builder.append(", y=");
        builder.append(this.y);
        builder.append(", width=");
        builder.append(this.width);
        builder.append(", height=");
        builder.append(this.height);
        builder.append("]");
        return builder.toString();
    }
}

