/*
 * Decompiled with CFR 0.152.
 */
package com.indvd00m.ascii.render.elements;

import com.indvd00m.ascii.render.Point;
import com.indvd00m.ascii.render.api.ICanvas;
import com.indvd00m.ascii.render.api.IContext;
import com.indvd00m.ascii.render.api.IElement;
import com.indvd00m.ascii.render.api.IPoint;

public class Dot
implements IElement {
    protected int x;
    protected int y;

    public Dot() {
        this.x = Integer.MIN_VALUE;
        this.y = Integer.MIN_VALUE;
    }

    public Dot(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public IPoint draw(ICanvas canvas, IContext context) {
        int x = this.x;
        int y = this.y;
        if (x == Integer.MIN_VALUE) {
            x = canvas.getWidth() / 2;
        }
        if (y == Integer.MIN_VALUE) {
            y = canvas.getHeight() / 2;
        }
        canvas.draw(x, y, "*");
        return new Point(x, y);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dot other = (Dot)obj;
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Dot [x=");
        builder.append(this.x);
        builder.append(", y=");
        builder.append(this.y);
        builder.append("]");
        return builder.toString();
    }
}

