/*
 * Decompiled with CFR 0.152.
 */
package com.indvd00m.ascii.render.elements;

import com.indvd00m.ascii.render.Point;
import com.indvd00m.ascii.render.api.ICanvas;
import com.indvd00m.ascii.render.api.IContext;
import com.indvd00m.ascii.render.api.IElement;
import com.indvd00m.ascii.render.api.IPoint;

public class Circle
implements IElement {
    protected int x;
    protected int y;
    protected int radius;

    public Circle() {
        this.x = Integer.MIN_VALUE;
        this.y = Integer.MIN_VALUE;
        this.radius = Integer.MIN_VALUE;
    }

    public Circle(int x, int y, int radius) {
        this.x = x;
        this.y = y;
        this.radius = radius;
    }

    public IPoint draw(ICanvas canvas, IContext context) {
        int x = this.x;
        int y = this.y;
        int radius = this.radius;
        if (x == Integer.MIN_VALUE) {
            x = canvas.getWidth() / 2;
        }
        if (y == Integer.MIN_VALUE) {
            y = canvas.getHeight() / 2;
        }
        if (radius == Integer.MIN_VALUE) {
            radius = Math.min(canvas.getWidth(), canvas.getHeight()) / 2;
        }
        for (int x1 = x - radius; x1 <= x + radius; ++x1) {
            for (int y1 = y - radius; y1 <= y + radius; ++y1) {
                double distance = Math.sqrt(Math.pow(x - x1, 2.0) + Math.pow(y - y1, 2.0));
                if (this.compare(radius, distance, 0.5) != 0) continue;
                canvas.draw(x1, y1, "*");
            }
        }
        return new Point(x, y);
    }

    protected int compare(double d1, double d2, double precision) {
        double diff = d1 - d2;
        if (Math.abs(diff) < precision) {
            return 0;
        }
        if (diff < 0.0) {
            return -1;
        }
        return 1;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getRadius() {
        return this.radius;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.radius;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Circle other = (Circle)obj;
        if (this.radius != other.radius) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Circle [x=");
        builder.append(this.x);
        builder.append(", y=");
        builder.append(this.y);
        builder.append(", radius=");
        builder.append(this.radius);
        builder.append("]");
        return builder.toString();
    }
}

