/*
 * Decompiled with CFR 0.152.
 */
package com.indvd00m.ascii.render;

import com.indvd00m.ascii.render.Canvas;
import com.indvd00m.ascii.render.ContextBuilder;
import com.indvd00m.ascii.render.api.ICanvas;
import com.indvd00m.ascii.render.api.IContext;
import com.indvd00m.ascii.render.api.IContextBuilder;
import com.indvd00m.ascii.render.api.IElement;
import com.indvd00m.ascii.render.api.ILayer;
import com.indvd00m.ascii.render.api.IRegion;
import com.indvd00m.ascii.render.api.IRender;

public class Render
implements IRender {
    public IContextBuilder newBuilder() {
        return ContextBuilder.newBuilder();
    }

    public ICanvas render(IContext context) {
        Canvas canvas = new Canvas(context.getWidth(), context.getHeight());
        for (ILayer layer : context.getLayers()) {
            IRegion region = layer.getRegion();
            Canvas layerCanvas = new Canvas(region.getWidth(), region.getHeight());
            for (IElement element : layer.getElements()) {
                element.draw((ICanvas)layerCanvas, context);
            }
            this.drawOver(canvas, layerCanvas, layer, region);
        }
        return canvas;
    }

    protected void drawOver(ICanvas c1, ICanvas c2, ILayer layer, IRegion region) {
        boolean opacity = layer.isOpacity();
        for (int c1x = region.getX(); c1x < region.getX() + region.getWidth(); ++c1x) {
            for (int c1y = region.getY(); c1y < region.getY() + region.getHeight(); ++c1y) {
                int c2x = c1x - region.getX();
                int c2y = c1y - region.getY();
                if (!opacity && !c2.isCharDrawed(c2x, c2y)) continue;
                char c = c2.getChar(c2x, c2y);
                c1.draw(c1x, c1y, c);
            }
        }
    }
}

