/*
 * Decompiled with CFR 0.152.
 */
package com.indvd00m.ascii.render;

import com.indvd00m.ascii.render.Context;
import com.indvd00m.ascii.render.Layer;
import com.indvd00m.ascii.render.Region;
import com.indvd00m.ascii.render.api.IContext;
import com.indvd00m.ascii.render.api.IContextBuilder;
import com.indvd00m.ascii.render.api.IElement;
import com.indvd00m.ascii.render.api.ILayer;
import com.indvd00m.ascii.render.api.IRegion;
import com.indvd00m.ascii.render.api.ITypedIdentified;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ContextBuilder
implements IContextBuilder {
    protected int width;
    protected int height;
    protected List<ILayer> layers = new ArrayList<ILayer>();
    protected Map<IElement, Set<ILayer>> layersByElement = new HashMap<IElement, Set<ILayer>>();
    protected Map<Class<IElement>, Set<IElement>> elementsByClass = new HashMap<Class<IElement>, Set<IElement>>();
    protected Map<Class<ITypedIdentified<?>>, Map<Integer, ITypedIdentified<?>>> identifiedByType = new HashMap();

    public static IContextBuilder newBuilder() {
        return new ContextBuilder();
    }

    public IContext build() {
        Context context = new Context();
        context.height = this.height;
        context.width = this.width;
        context.layers.addAll(this.layers);
        context.layersByElement.putAll(this.layersByElement);
        context.elementsByClass.putAll(this.elementsByClass);
        context.identifiedByType.putAll(this.identifiedByType);
        return context;
    }

    public IContextBuilder width(int width) {
        this.width = width;
        return this;
    }

    public IContextBuilder height(int height) {
        this.height = height;
        return this;
    }

    void addLayer(Layer layer) {
        this.layers.add(layer);
    }

    void addElementToLayer(Layer layer, IElement element) {
        layer.elements.add(element);
        Set<ILayer> set = this.layersByElement.get(element);
        if (set == null) {
            set = new LinkedHashSet<ILayer>();
            this.layersByElement.put(element, set);
        }
        set.add(layer);
        LinkedHashSet<Class<?>> ancestors = this.getAncestors(element.getClass());
        for (Class clazz : ancestors) {
            Set<IElement> set2 = this.elementsByClass.get(clazz);
            if (set2 == null) {
                set2 = new LinkedHashSet<IElement>();
                this.elementsByClass.put(clazz, set2);
            }
            set2.add(element);
        }
        for (Class clazz : ancestors) {
            if (!ITypedIdentified.class.isAssignableFrom(clazz)) continue;
            ITypedIdentified ti = (ITypedIdentified)element;
            int typedId = ti.getTypedId();
            Map<Integer, ITypedIdentified<?>> map = this.identifiedByType.get(clazz);
            if (map == null) {
                map = new HashMap();
                this.identifiedByType.put(clazz, map);
            }
            map.put(typedId, ti);
        }
    }

    public IContextBuilder layer() {
        Layer layer = new Layer(new Region(0, 0, this.width, this.height));
        this.addLayer(layer);
        return this;
    }

    public IContextBuilder layer(IRegion region) {
        Layer layer = new Layer(region);
        this.addLayer(layer);
        return this;
    }

    public IContextBuilder layer(int x, int y, int width, int height) {
        return this.layer(new Region(x, y, width, height));
    }

    public IContextBuilder layer(IElement ... elements) {
        Layer layer = new Layer(new Region(0, 0, this.width, this.height));
        this.addLayer(layer);
        for (IElement element : elements) {
            this.addElementToLayer(layer, element);
        }
        return this;
    }

    public IContextBuilder layer(IRegion region, IElement ... elements) {
        Layer layer = new Layer(region);
        this.addLayer(layer);
        for (IElement element : elements) {
            this.addElementToLayer(layer, element);
        }
        return this;
    }

    public IContextBuilder layer(int x, int y, int width, int height, IElement ... elements) {
        return this.layer((IRegion)new Region(x, y, width, height), elements);
    }

    public IContextBuilder layer(List<IElement> elements) {
        Layer layer = new Layer(new Region(0, 0, this.width, this.height));
        this.addLayer(layer);
        for (IElement element : elements) {
            this.addElementToLayer(layer, element);
        }
        return this;
    }

    public IContextBuilder layer(IRegion region, List<IElement> elements) {
        Layer layer = new Layer(region);
        this.addLayer(layer);
        for (IElement element : elements) {
            this.addElementToLayer(layer, element);
        }
        return this;
    }

    public IContextBuilder layer(int x, int y, int width, int height, List<IElement> elements) {
        return this.layer((IRegion)new Region(x, y, width, height), elements);
    }

    public IContextBuilder opacity(boolean opacity) {
        if (this.layers.isEmpty()) {
            this.layer();
        }
        Layer layer = (Layer)this.layers.get(this.layers.size() - 1);
        layer.opacity = opacity;
        return this;
    }

    public IContextBuilder element(IElement element) {
        if (this.layers.isEmpty()) {
            this.layer();
        }
        Layer layer = (Layer)this.layers.get(this.layers.size() - 1);
        this.addElementToLayer(layer, element);
        return this;
    }

    public IContextBuilder elements(IElement ... elements) {
        if (this.layers.isEmpty()) {
            this.layer();
        }
        Layer layer = (Layer)this.layers.get(this.layers.size() - 1);
        for (IElement element : elements) {
            this.addElementToLayer(layer, element);
        }
        return this;
    }

    public IContextBuilder elements(List<IElement> elements) {
        if (this.layers.isEmpty()) {
            this.layer();
        }
        Layer layer = (Layer)this.layers.get(this.layers.size() - 1);
        for (IElement element : elements) {
            this.addElementToLayer(layer, element);
        }
        return this;
    }

    protected LinkedHashSet<Class<?>> getAncestors(Class<?> clazz) {
        LinkedHashSet ancestors = new LinkedHashSet();
        if (clazz == null) {
            return ancestors;
        }
        ancestors.add(clazz);
        for (Class<?> iClazz : clazz.getInterfaces()) {
            ancestors.add(iClazz);
        }
        ancestors.addAll(this.getAncestors(clazz.getSuperclass()));
        return ancestors;
    }
}

