/*
 * Decompiled with CFR 0.152.
 */
package com.indvd00m.ascii.render;

import com.indvd00m.ascii.render.Point;
import com.indvd00m.ascii.render.api.IContext;
import com.indvd00m.ascii.render.api.IElement;
import com.indvd00m.ascii.render.api.ILayer;
import com.indvd00m.ascii.render.api.IPoint;
import com.indvd00m.ascii.render.api.IRegion;
import com.indvd00m.ascii.render.api.ITypedIdentified;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Context
implements IContext {
    protected int width;
    protected int height;
    protected List<ILayer> layers = new ArrayList<ILayer>();
    protected Map<IElement, Set<ILayer>> layersByElement = new HashMap<IElement, Set<ILayer>>();
    protected Map<Class<IElement>, Set<IElement>> elementsByClass = new HashMap<Class<IElement>, Set<IElement>>();
    protected Map<Class<ITypedIdentified<?>>, Map<Integer, ITypedIdentified<?>>> identifiedByType = new HashMap();

    Context() {
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public List<ILayer> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public <E extends IElement> E lookup(Class<E> clazz) {
        return this.lookup(clazz, true);
    }

    public <E extends IElement> E lookup(Class<E> clazz, boolean includeSuccessors) {
        List<E> elements = this.lookupAll(clazz, includeSuccessors);
        if (!elements.isEmpty()) {
            return (E)((IElement)elements.get(0));
        }
        return null;
    }

    public <E extends IElement> List<E> lookupAll(Class<E> clazz) {
        return this.lookupAll(clazz, true);
    }

    public <E extends IElement> List<E> lookupAll(Class<E> clazz, boolean includeSuccessors) {
        LinkedHashSet<IElement> set = new LinkedHashSet<IElement>();
        Set<IElement> elements = this.elementsByClass.get(clazz);
        if (elements != null) {
            for (IElement e : elements) {
                if (!includeSuccessors && !clazz.equals(e.getClass())) continue;
                set.add(e);
            }
        }
        if (includeSuccessors) {
            for (Class<IElement> nextClazz : this.elementsByClass.keySet()) {
                Set<IElement> elements2;
                if (!clazz.isAssignableFrom(nextClazz) || (elements2 = this.elementsByClass.get(nextClazz)) == null) continue;
                set.addAll(elements2);
            }
        }
        return new ArrayList(set);
    }

    public <E extends IElement> E lookup(Class<E> clazz, ILayer layer) {
        return this.lookup(clazz, true, layer);
    }

    public <E extends IElement> E lookup(Class<E> clazz, boolean includeSuccessors, ILayer layer) {
        List<E> elements = this.lookupAll(clazz, includeSuccessors, layer);
        if (!elements.isEmpty()) {
            return (E)((IElement)elements.get(0));
        }
        return null;
    }

    public <E extends IElement> List<E> lookupAll(Class<E> clazz, ILayer layer) {
        return this.lookupAll(clazz, true, layer);
    }

    public <E extends IElement> List<E> lookupAll(Class<E> clazz, boolean includeSuccessors, ILayer layer) {
        LinkedHashSet<IElement> set = new LinkedHashSet<IElement>();
        Set<IElement> elements = this.elementsByClass.get(clazz);
        if (elements != null) {
            for (IElement e : elements) {
                Set<ILayer> elementLayers;
                if (!includeSuccessors && !clazz.equals(e.getClass()) || !(elementLayers = this.layersByElement.get(e)).contains(layer)) continue;
                set.add(e);
            }
        }
        if (includeSuccessors) {
            for (Class<IElement> nextClazz : this.elementsByClass.keySet()) {
                Set<IElement> elements2;
                if (!clazz.isAssignableFrom(nextClazz) || (elements2 = this.elementsByClass.get(nextClazz)) == null) continue;
                for (IElement e : elements2) {
                    Set<ILayer> elementLayers = this.layersByElement.get(e);
                    if (!elementLayers.contains(layer)) continue;
                    set.add(e);
                }
            }
        }
        return new ArrayList(set);
    }

    public ILayer lookupLayer(IElement element) {
        Set<ILayer> elementLayers = this.layersByElement.get(element);
        if (elementLayers != null && !elementLayers.isEmpty()) {
            return elementLayers.iterator().next();
        }
        return null;
    }

    public List<ILayer> lookupLayers(IElement element) {
        ArrayList<ILayer> list = new ArrayList<ILayer>();
        Set<ILayer> elementLayers = this.layersByElement.get(element);
        if (elementLayers != null) {
            list.addAll(elementLayers);
        }
        return list;
    }

    public <T extends ITypedIdentified<T>> T lookupTyped(Class<T> type, int typedId) {
        return this.lookupTyped(type, typedId, true);
    }

    public <T extends ITypedIdentified<T>> T lookupTyped(Class<T> type, int typedId, boolean includeSuccessors) {
        Map<Integer, ITypedIdentified<?>> map = this.identifiedByType.get(type);
        if (map != null && map.containsKey(typedId)) {
            ITypedIdentified<?> ti = map.get(typedId);
            if (includeSuccessors || type.equals(ti.getClass())) {
                return (T)ti;
            }
        }
        if (includeSuccessors) {
            for (Class<ITypedIdentified<?>> nextType : this.identifiedByType.keySet()) {
                Map<Integer, ITypedIdentified<?>> map2;
                if (!type.isAssignableFrom(nextType) || (map2 = this.identifiedByType.get(nextType)) == null || !map2.containsKey(typedId)) continue;
                ITypedIdentified<?> ti = map2.get(typedId);
                return (T)ti;
            }
        }
        return null;
    }

    public <T extends ITypedIdentified<T>> List<T> lookupTyped(Class<T> type) {
        return this.lookupTyped(type, true);
    }

    public <T extends ITypedIdentified<T>> List<T> lookupTyped(Class<T> type, boolean includeSuccessors) {
        LinkedHashSet set = new LinkedHashSet();
        Map<Integer, ITypedIdentified<?>> map = this.identifiedByType.get(type);
        if (map != null) {
            for (ITypedIdentified<?> ti : map.values()) {
                if (!includeSuccessors && !type.equals(ti.getClass())) continue;
                set.add(ti);
            }
        }
        if (includeSuccessors) {
            for (Class<ITypedIdentified<?>> nextType : this.identifiedByType.keySet()) {
                Map<Integer, ITypedIdentified<?>> map2;
                if (!type.isAssignableFrom(nextType) || (map2 = this.identifiedByType.get(nextType)) == null) continue;
                set.addAll(map2.values());
            }
        }
        return new ArrayList(set);
    }

    public boolean contains(IElement element) {
        return this.layersByElement.containsKey(element);
    }

    public IPoint transform(IPoint point, ILayer source, ILayer target) {
        IRegion sourceRegion = source.getRegion();
        IRegion targetRegion = target.getRegion();
        int px = point.getX();
        int py = point.getY();
        int sx = sourceRegion.getX();
        int sy = sourceRegion.getY();
        int tx = targetRegion.getX();
        int ty = targetRegion.getY();
        int x = sx - tx + px;
        int y = sy - ty + py;
        return new Point(x, y);
    }

    public IPoint transform(IPoint point, IElement source, IElement target) {
        ILayer sourceLayer = this.lookupLayer(source);
        ILayer targetLayer = this.lookupLayer(target);
        return this.transform(point, sourceLayer, targetLayer);
    }
}

