/*
 * Decompiled with CFR 0.152.
 */
package com.indvd00m.ascii.render;

import com.indvd00m.ascii.render.Region;
import com.indvd00m.ascii.render.api.ICanvas;
import com.indvd00m.ascii.render.api.IRegion;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Canvas
implements ICanvas {
    public static final char NULL_CHAR = '\u0000';
    protected final int width;
    protected final int height;
    protected final List<StringBuilder> lines;
    protected String cachedText;
    protected String cachedLines;
    protected boolean needUpdateCache = false;

    public Canvas(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException();
        }
        if (height < 0) {
            throw new IllegalArgumentException();
        }
        this.width = width;
        this.height = height;
        this.lines = new ArrayList<StringBuilder>(height);
        this.clear();
    }

    protected void updateCacheIfNeed() {
        if (this.needUpdateCache) {
            this.updateCache();
            this.needUpdateCache = false;
        }
    }

    protected void updateCache() {
        String text;
        StringBuilder sb = new StringBuilder();
        Iterator<StringBuilder> it = this.lines.iterator();
        while (it.hasNext()) {
            StringBuilder line = it.next();
            sb.append((CharSequence)line);
            if (!it.hasNext()) continue;
            sb.append('\n');
        }
        this.cachedLines = text = sb.toString();
        this.cachedText = text.replace('\u0000', ' ');
    }

    protected String repeatChar(char c, int count) {
        return this.repeatString(c + "", count);
    }

    protected String repeatString(String s, int count) {
        String repeated = new String(new char[count]).replace("\u0000", s);
        return repeated;
    }

    public void draw(int x, int y, char c) {
        this.draw(x, y, c + "");
    }

    public void draw(int x, int y, char c, int count) {
        this.draw(x, y, c + "", count);
    }

    public void draw(int x, int y, String s) {
        if (x >= this.width) {
            return;
        }
        if (y >= this.height) {
            return;
        }
        if (s.matches("(?s).*[\\n\\r]+.*")) {
            for (String line : s.split("[\\n\\r]")) {
                this.draw(x, y++, line);
                if (y >= this.height) break;
            }
            return;
        }
        if (y < 0) {
            return;
        }
        if (x < 0) {
            s = -x > s.length() - 1 ? "" : s.substring(-x);
        }
        if (s.length() > this.width - x) {
            s = s.substring(0, this.width - x);
        }
        if (x < 0) {
            x = 0;
        }
        StringBuilder line = this.lines.get(y);
        line.replace(x, x + s.length(), s);
        this.needUpdateCache = true;
    }

    public void draw(int x, int y, String s, int count) {
        if (count <= 0) {
            return;
        }
        this.draw(x, y, this.repeatString(s, count));
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getText() {
        this.updateCacheIfNeed();
        return this.cachedText;
    }

    public String toString() {
        return this.getText();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Canvas canvas = (Canvas)o;
        this.updateCacheIfNeed();
        canvas.updateCacheIfNeed();
        if (this.width != canvas.width) {
            return false;
        }
        if (this.height != canvas.height) {
            return false;
        }
        return this.cachedLines.equals(canvas.cachedLines);
    }

    public int hashCode() {
        this.updateCacheIfNeed();
        int result = this.width;
        result = 31 * result + this.height;
        result = 31 * result + this.cachedLines.hashCode();
        return result;
    }

    public void clear() {
        this.lines.clear();
        for (int y = 0; y < this.height; ++y) {
            StringBuilder line = new StringBuilder(this.width);
            line.append(new char[this.width]);
            this.lines.add(line);
        }
        this.needUpdateCache = true;
    }

    public char getChar(int x, int y) {
        if (x < 0 || x >= this.width) {
            return '\u0000';
        }
        if (y < 0 || y >= this.height) {
            return '\u0000';
        }
        StringBuilder line = this.lines.get(y);
        char c = line.charAt(x);
        return c;
    }

    public char setChar(int x, int y, char c) {
        if (x < 0 || x >= this.width) {
            return '\u0000';
        }
        if (y < 0 || y >= this.height) {
            return '\u0000';
        }
        StringBuilder line = this.lines.get(y);
        char prevC = line.charAt(x);
        line.setCharAt(x, c);
        this.needUpdateCache = true;
        return prevC;
    }

    public boolean isCharDrawed(int x, int y) {
        return this.getChar(x, y) != '\u0000';
    }

    public ICanvas trim() {
        IRegion region = this.getTrimmedRegion(this, ' ', '\u0000');
        return this.subCanvas(region);
    }

    public ICanvas trimSpaces() {
        return this.trim(' ');
    }

    public ICanvas trimNulls() {
        return this.trim('\u0000');
    }

    public ICanvas trim(char trimChar) {
        IRegion region = this.getTrimmedRegion(this, trimChar);
        return this.subCanvas(region);
    }

    protected IRegion getTrimmedRegion(ICanvas canvas, char trimChar) {
        int regionHeight;
        int regionWidth;
        char c;
        int y;
        int x;
        int w = canvas.getWidth();
        int h = canvas.getHeight();
        int firstX = w;
        int firstY = h;
        int lastX = 0;
        int lastY = 0;
        block0: for (x = 0; x < w; ++x) {
            for (y = 0; y < h; ++y) {
                c = canvas.getChar(x, y);
                if (c == trimChar) continue;
                firstX = x;
                break block0;
            }
        }
        if (firstX != w) {
            int x2;
            int y2;
            block2: for (y2 = 0; y2 < h; ++y2) {
                for (x2 = 0; x2 < w; ++x2) {
                    c = canvas.getChar(x2, y2);
                    if (c == trimChar) continue;
                    firstY = y2;
                    break block2;
                }
            }
            block4: for (x = w - 1; x >= 0; --x) {
                for (y = h - 1; y >= 0; --y) {
                    c = canvas.getChar(x, y);
                    if (c == trimChar) continue;
                    lastX = x;
                    break block4;
                }
            }
            block6: for (y2 = h - 1; y2 >= 0; --y2) {
                for (x2 = w - 1; x2 >= 0; --x2) {
                    c = canvas.getChar(x2, y2);
                    if (c == trimChar) continue;
                    lastY = y2;
                    break block6;
                }
            }
        }
        if ((regionWidth = lastX - firstX + 1) < 0) {
            regionWidth = 0;
        }
        if ((regionHeight = lastY - firstY + 1) < 0) {
            regionHeight = 0;
        }
        Region region = new Region(firstX, firstY, regionWidth, regionHeight);
        return region;
    }

    protected IRegion getTrimmedRegion(ICanvas canvas, char trimChar1, char trimChar2) {
        int regionHeight;
        int regionWidth;
        char c;
        int y;
        int x;
        int w = canvas.getWidth();
        int h = canvas.getHeight();
        int firstX = w;
        int firstY = h;
        int lastX = 0;
        int lastY = 0;
        block0: for (x = 0; x < w; ++x) {
            for (y = 0; y < h; ++y) {
                c = canvas.getChar(x, y);
                if (c == trimChar1 || c == trimChar2) continue;
                firstX = x;
                break block0;
            }
        }
        if (firstX != w) {
            int x2;
            int y2;
            block2: for (y2 = 0; y2 < h; ++y2) {
                for (x2 = 0; x2 < w; ++x2) {
                    c = canvas.getChar(x2, y2);
                    if (c == trimChar1 || c == trimChar2) continue;
                    firstY = y2;
                    break block2;
                }
            }
            block4: for (x = w - 1; x >= 0; --x) {
                for (y = h - 1; y >= 0; --y) {
                    c = canvas.getChar(x, y);
                    if (c == trimChar1 || c == trimChar2) continue;
                    lastX = x;
                    break block4;
                }
            }
            block6: for (y2 = h - 1; y2 >= 0; --y2) {
                for (x2 = w - 1; x2 >= 0; --x2) {
                    c = canvas.getChar(x2, y2);
                    if (c == trimChar1 || c == trimChar2) continue;
                    lastY = y2;
                    break block6;
                }
            }
        }
        if ((regionWidth = lastX - firstX + 1) < 0) {
            regionWidth = 0;
        }
        if ((regionHeight = lastY - firstY + 1) < 0) {
            regionHeight = 0;
        }
        Region region = new Region(firstX, firstY, regionWidth, regionHeight);
        return region;
    }

    public ICanvas subCanvas(IRegion region) {
        int trimWidth = region.getWidth();
        int trimHeight = region.getHeight();
        int trimX = region.getX();
        int trimY = region.getY();
        Canvas canvas = new Canvas(trimWidth, trimHeight);
        for (int x = 0; x < trimWidth; ++x) {
            for (int y = 0; y < trimHeight; ++y) {
                char c = this.getChar(trimX + x, trimY + y);
                canvas.setChar(x, y, c);
            }
        }
        return canvas;
    }
}

