/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee.util;

import com.imaginarycode.minecraft.redisbungee.RedisBungee;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.Jedis;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.exceptions.JedisConnectionException;
import java.beans.ConstructorProperties;
import java.util.concurrent.Callable;
import java.util.logging.Level;

public abstract class RedisCallable<T>
implements Callable<T>,
Runnable {
    private final RedisBungee plugin;

    @Override
    public T call() {
        return this.run(false);
    }

    @Override
    public void run() {
        this.call();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private T run(boolean retry) {
        try (Jedis jedis = this.plugin.getPool().getResource();){
            T t = this.call(jedis);
            return t;
        }
        catch (JedisConnectionException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Unable to get connection", e);
            if (retry) throw new RuntimeException("task failed to run");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                throw new RuntimeException("task failed to run", e1);
            }
            this.run(true);
            throw new RuntimeException("task failed to run");
        }
    }

    protected abstract T call(Jedis var1);

    @ConstructorProperties(value={"plugin"})
    public RedisCallable(RedisBungee plugin) {
        this.plugin = plugin;
    }
}

