/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee.util;

import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;

public class InternalCache<K, V> {
    private final ConcurrentMap<K, Holder> map = new ConcurrentHashMap<K, Holder>(128, 0.75f, 4);
    private final long entryWriteExpiry;

    public InternalCache() {
        this.entryWriteExpiry = 0L;
    }

    public InternalCache(long entryWriteExpiry) {
        this.entryWriteExpiry = entryWriteExpiry;
    }

    public V get(K key, Callable<V> loader) throws ExecutionException {
        Holder value = (Holder)this.map.get(key);
        if (value == null || this.entryWriteExpiry > 0L && System.currentTimeMillis() > value.expiry) {
            V freshValue;
            try {
                freshValue = loader.call();
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
            if (freshValue == null) {
                return null;
            }
            value = new Holder(freshValue, System.currentTimeMillis() + this.entryWriteExpiry);
            this.map.putIfAbsent(key, value);
        }
        return (V)value.value;
    }

    public V put(K key, V value) {
        Holder holder = this.map.put(key, new Holder(value, System.currentTimeMillis() + this.entryWriteExpiry));
        if (holder == null) {
            return null;
        }
        return (V)holder.value;
    }

    public void invalidate(K key) {
        this.map.remove(key);
    }

    public void cleanup() {
        if (this.entryWriteExpiry <= 0L) {
            return;
        }
        long fixedReference = System.currentTimeMillis();
        Iterator it = this.map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (((Holder)entry.getValue()).expiry <= fixedReference) continue;
            it.remove();
        }
    }

    private class Holder {
        private final V value;
        private final long expiry;

        @ConstructorProperties(value={"value", "expiry"})
        public Holder(V value, long expiry) {
            this.value = value;
            this.expiry = expiry;
        }

        public V getValue() {
            return this.value;
        }

        public long getExpiry() {
            return this.expiry;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Holder)) {
                return false;
            }
            Holder other = (Holder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            return this.getExpiry() == other.getExpiry();
        }

        public boolean canEqual(Object other) {
            return other instanceof Holder;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            Object $value = this.getValue();
            result = result * 31 + ($value == null ? 0 : $value.hashCode());
            long $expiry = this.getExpiry();
            result = result * 31 + (int)($expiry >>> 32 ^ $expiry);
            return result;
        }

        public String toString() {
            return "InternalCache.Holder(value=" + this.getValue() + ", expiry=" + this.getExpiry() + ")";
        }
    }
}

