/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee.internal.jedis;

import com.imaginarycode.minecraft.redisbungee.internal.commonspool2.impl.GenericObjectPoolConfig;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.HostAndPort;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.Jedis;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.JedisClusterInfoCache;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.JedisPool;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.exceptions.JedisConnectionException;
import java.util.Map;
import java.util.Set;

public abstract class JedisClusterConnectionHandler {
    protected final JedisClusterInfoCache cache;
    private int timeout;

    abstract Jedis getConnection();

    public void returnConnection(Jedis connection) {
        this.cache.getNode(JedisClusterInfoCache.getNodeKey(connection.getClient())).returnResource(connection);
    }

    public void returnBrokenConnection(Jedis connection) {
        this.cache.getNode(JedisClusterInfoCache.getNodeKey(connection.getClient())).returnBrokenResource(connection);
    }

    abstract Jedis getConnectionFromSlot(int var1);

    public Jedis getConnectionFromNode(HostAndPort node) {
        this.cache.setNodeIfNotExist(node);
        return this.cache.getNode(JedisClusterInfoCache.getNodeKey(node)).getResource();
    }

    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig poolConfig, int timeout) {
        this.cache = new JedisClusterInfoCache(poolConfig, timeout);
        this.initializeSlotsCache(nodes, poolConfig);
    }

    public Map<String, JedisPool> getNodes() {
        return this.cache.getNodes();
    }

    public void assignSlotToNode(int slot, HostAndPort targetNode) {
        this.cache.assignSlotToNode(slot, targetNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSlotsCache(Set<HostAndPort> startNodes, GenericObjectPoolConfig poolConfig) {
        for (HostAndPort hostAndPort : startNodes) {
            Jedis jedis = new Jedis(hostAndPort.getHost(), hostAndPort.getPort());
            try {
                this.cache.discoverClusterNodesAndSlots(jedis);
                break;
            }
            catch (JedisConnectionException e) {}
            continue;
            finally {
                if (jedis == null) continue;
                jedis.close();
            }
        }
        for (HostAndPort node : startNodes) {
            this.cache.setNodeIfNotExist(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renewSlotCache() {
        for (JedisPool jp : this.cache.getNodes().values()) {
            Jedis jedis = null;
            try {
                jedis = jp.getResource();
                this.cache.discoverClusterSlots(jedis);
                break;
            }
            catch (JedisConnectionException e) {}
            continue;
            finally {
                if (jedis == null) continue;
                jedis.close();
            }
        }
    }
}

