/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee.internal.commonspool2.proxy;

import com.imaginarycode.minecraft.redisbungee.internal.commonspool2.UsageTracking;
import com.imaginarycode.minecraft.redisbungee.internal.commonspool2.proxy.JdkProxyHandler;
import com.imaginarycode.minecraft.redisbungee.internal.commonspool2.proxy.ProxySource;
import java.lang.reflect.Proxy;

public class JdkProxySource<T>
implements ProxySource<T> {
    private final ClassLoader classLoader;
    private final Class<?>[] interfaces;

    public JdkProxySource(ClassLoader classLoader, Class<?>[] interfaces) {
        this.classLoader = classLoader;
        this.interfaces = new Class[interfaces.length];
        System.arraycopy(interfaces, 0, this.interfaces, 0, interfaces.length);
    }

    @Override
    public T createProxy(T pooledObject, UsageTracking<T> usageTracking) {
        Object proxy = Proxy.newProxyInstance(this.classLoader, this.interfaces, new JdkProxyHandler<T>(pooledObject, usageTracking));
        return (T)proxy;
    }

    @Override
    public T resolveProxy(T proxy) {
        JdkProxyHandler jdkProxyHandler = (JdkProxyHandler)Proxy.getInvocationHandler(proxy);
        Object pooledObject = jdkProxyHandler.disableProxy();
        return pooledObject;
    }
}

