/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee;

import com.google.common.collect.ImmutableList;
import com.google.common.net.InetAddresses;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.JedisPool;
import java.net.InetAddress;
import java.util.List;
import net.md_5.bungee.config.Configuration;

public class RedisBungeeConfiguration {
    private final JedisPool pool;
    private final String serverId;
    private final boolean registerBungeeCommands;
    private final List<InetAddress> exemptAddresses;

    public RedisBungeeConfiguration(JedisPool pool, Configuration configuration) {
        this.pool = pool;
        this.serverId = configuration.getString("server-id");
        this.registerBungeeCommands = configuration.getBoolean("register-bungee-commands", true);
        List stringified = configuration.getStringList("exempt-ip-addresses");
        ImmutableList.Builder addressBuilder = ImmutableList.builder();
        for (String s : stringified) {
            addressBuilder.add((Object)InetAddresses.forString((String)s));
        }
        this.exemptAddresses = addressBuilder.build();
    }

    public JedisPool getPool() {
        return this.pool;
    }

    public String getServerId() {
        return this.serverId;
    }

    public boolean isRegisterBungeeCommands() {
        return this.registerBungeeCommands;
    }

    public List<InetAddress> getExemptAddresses() {
        return this.exemptAddresses;
    }
}

