/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee.util;

import com.google.common.collect.ImmutableList;
import com.imaginarycode.minecraft.redisbungee.RedisBungee;
import com.imaginarycode.minecraft.redisbungee.internal.okhttp.MediaType;
import com.imaginarycode.minecraft.redisbungee.internal.okhttp.OkHttpClient;
import com.imaginarycode.minecraft.redisbungee.internal.okhttp.Request;
import com.imaginarycode.minecraft.redisbungee.internal.okhttp.RequestBody;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;

public class UUIDFetcher
implements Callable<Map<String, UUID>> {
    private static final double PROFILES_PER_REQUEST = 100.0;
    private static final String PROFILE_URL = "https://api.mojang.com/profiles/minecraft";
    private static final MediaType JSON = MediaType.parse("application/json");
    private final List<String> names;
    private final boolean rateLimiting;
    private static OkHttpClient httpClient;

    private UUIDFetcher(List<String> names, boolean rateLimiting) {
        this.names = ImmutableList.copyOf(names);
        this.rateLimiting = rateLimiting;
    }

    public UUIDFetcher(List<String> names) {
        this(names, true);
    }

    public static UUID getUUID(String id) {
        return UUID.fromString(id.substring(0, 8) + "-" + id.substring(8, 12) + "-" + id.substring(12, 16) + "-" + id.substring(16, 20) + "-" + id.substring(20, 32));
    }

    @Override
    public Map<String, UUID> call() throws Exception {
        HashMap<String, UUID> uuidMap = new HashMap<String, UUID>();
        int requests = (int)Math.ceil((double)this.names.size() / 100.0);
        for (int i = 0; i < requests; ++i) {
            Profile[] array;
            String body = RedisBungee.getGson().toJson(this.names.subList(i * 100, Math.min((i + 1) * 100, this.names.size())));
            Request request = new Request.Builder().url(PROFILE_URL).post(RequestBody.create(JSON, body)).build();
            String response = httpClient.newCall(request).execute().body().string();
            for (Profile profile : array = (Profile[])RedisBungee.getGson().fromJson(response, Profile[].class)) {
                UUID uuid = UUIDFetcher.getUUID(profile.id);
                uuidMap.put(profile.name, uuid);
            }
            if (!this.rateLimiting || i == requests - 1) continue;
            Thread.sleep(100L);
        }
        return uuidMap;
    }

    public static void setHttpClient(OkHttpClient httpClient) {
        UUIDFetcher.httpClient = httpClient;
    }

    private static class Profile {
        String id;
        String name;

        private Profile() {
        }
    }
}

