/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee.internal.jedis.params.geo;

import com.imaginarycode.minecraft.redisbungee.internal.jedis.Protocol;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.params.Params;
import com.imaginarycode.minecraft.redisbungee.internal.jedisutil.SafeEncoder;
import java.util.ArrayList;

public class GeoRadiusParam
extends Params {
    private static final String WITHCOORD = "withcoord";
    private static final String WITHDIST = "withdist";
    private static final String ASC = "asc";
    private static final String DESC = "desc";
    private static final String COUNT = "count";

    private GeoRadiusParam() {
    }

    public static GeoRadiusParam geoRadiusParam() {
        return new GeoRadiusParam();
    }

    public GeoRadiusParam withCoord() {
        this.addParam(WITHCOORD);
        return this;
    }

    public GeoRadiusParam withDist() {
        this.addParam(WITHDIST);
        return this;
    }

    public GeoRadiusParam sortAscending() {
        this.addParam(ASC);
        return this;
    }

    public GeoRadiusParam sortDescending() {
        this.addParam(DESC);
        return this;
    }

    public GeoRadiusParam count(int count) {
        if (count > 0) {
            this.addParam(COUNT, count);
        }
        return this;
    }

    public byte[][] getByteParams(byte[] ... args) {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        for (byte[] arg : args) {
            byteParams.add(arg);
        }
        if (this.contains(WITHCOORD)) {
            byteParams.add(SafeEncoder.encode(WITHCOORD));
        }
        if (this.contains(WITHDIST)) {
            byteParams.add(SafeEncoder.encode(WITHDIST));
        }
        if (this.contains(COUNT)) {
            byteParams.add(SafeEncoder.encode(COUNT));
            byteParams.add(Protocol.toByteArray((Integer)this.getParam(COUNT)));
        }
        if (this.contains(ASC)) {
            byteParams.add(SafeEncoder.encode(ASC));
        } else if (this.contains(DESC)) {
            byteParams.add(SafeEncoder.encode(DESC));
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }
}

