/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee.internal.jedis;

import com.imaginarycode.minecraft.redisbungee.internal.commonspool2.impl.GenericObjectPoolConfig;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.HostAndPort;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.Jedis;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.JedisFactory;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.JedisPubSub;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.exceptions.JedisConnectionException;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.exceptions.JedisException;
import com.imaginarycode.minecraft.redisbungee.internal.jedisutil.Pool;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JedisSentinelPool
extends Pool<Jedis> {
    protected GenericObjectPoolConfig poolConfig;
    protected int connectionTimeout = 2000;
    protected int soTimeout = 2000;
    protected String password;
    protected int database = 0;
    protected String clientName;
    protected Set<MasterListener> masterListeners = new HashSet<MasterListener>();
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private volatile JedisFactory factory;
    private volatile HostAndPort currentHostMaster;

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig) {
        this(masterName, sentinels, poolConfig, 2000, null, 0);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels) {
        this(masterName, sentinels, new GenericObjectPoolConfig(), 2000, null, 0);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, String password) {
        this(masterName, sentinels, new GenericObjectPoolConfig(), 2000, password);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, String password) {
        this(masterName, sentinels, poolConfig, timeout, password, 0);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout) {
        this(masterName, sentinels, poolConfig, timeout, null, 0);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, String password) {
        this(masterName, sentinels, poolConfig, 2000, password);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, String password, int database) {
        this(masterName, sentinels, poolConfig, timeout, timeout, password, database);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, String password, int database, String clientName) {
        this(masterName, sentinels, poolConfig, timeout, timeout, password, database, clientName);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, int soTimeout, String password, int database) {
        this(masterName, sentinels, poolConfig, timeout, soTimeout, password, database, null);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout, String password, int database, String clientName) {
        this.poolConfig = poolConfig;
        this.connectionTimeout = connectionTimeout;
        this.soTimeout = soTimeout;
        this.password = password;
        this.database = database;
        this.clientName = clientName;
        HostAndPort master = this.initSentinels(sentinels, masterName);
        this.initPool(master);
    }

    @Override
    public void destroy() {
        for (MasterListener m : this.masterListeners) {
            m.shutdown();
        }
        super.destroy();
    }

    public HostAndPort getCurrentHostMaster() {
        return this.currentHostMaster;
    }

    private void initPool(HostAndPort master) {
        if (!master.equals(this.currentHostMaster)) {
            this.currentHostMaster = master;
            if (this.factory == null) {
                this.factory = new JedisFactory(master.getHost(), master.getPort(), this.connectionTimeout, this.soTimeout, this.password, this.database, this.clientName);
                this.initPool(this.poolConfig, this.factory);
            } else {
                this.factory.setHostAndPort(this.currentHostMaster);
                this.internalPool.clear();
            }
            this.log.info("Created JedisPool to master at " + master);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostAndPort initSentinels(Set<String> sentinels, String masterName) {
        HostAndPort hap;
        HostAndPort master = null;
        boolean sentinelAvailable = false;
        this.log.info("Trying to find master from available Sentinels...");
        for (String sentinel : sentinels) {
            hap = this.toHostAndPort(Arrays.asList(sentinel.split(":")));
            this.log.fine("Connecting to Sentinel " + hap);
            Jedis jedis = null;
            try {
                jedis = new Jedis(hap.getHost(), hap.getPort());
                List<String> masterAddr = jedis.sentinelGetMasterAddrByName(masterName);
                sentinelAvailable = true;
                if (masterAddr == null || masterAddr.size() != 2) {
                    this.log.warning("Can not get master addr, master name: " + masterName + ". Sentinel: " + hap + ".");
                    continue;
                }
                master = this.toHostAndPort(masterAddr);
                this.log.fine("Found Redis master at " + master);
                break;
            }
            catch (JedisException e) {
                this.log.warning("Cannot get master address from sentinel running @ " + hap + ". Reason: " + e + ". Trying next one.");
            }
            finally {
                if (jedis == null) continue;
                jedis.close();
            }
        }
        if (master == null) {
            if (sentinelAvailable) {
                throw new JedisException("Can connect to sentinel, but " + masterName + " seems to be not monitored...");
            }
            throw new JedisConnectionException("All sentinels down, cannot determine where is " + masterName + " master is running...");
        }
        this.log.info("Redis master running at " + master + ", starting Sentinel listeners...");
        for (String sentinel : sentinels) {
            hap = this.toHostAndPort(Arrays.asList(sentinel.split(":")));
            MasterListener masterListener = new MasterListener(masterName, hap.getHost(), hap.getPort());
            masterListener.setDaemon(true);
            this.masterListeners.add(masterListener);
            masterListener.start();
        }
        return master;
    }

    private HostAndPort toHostAndPort(List<String> getMasterAddrByNameResult) {
        String host = getMasterAddrByNameResult.get(0);
        int port = Integer.parseInt(getMasterAddrByNameResult.get(1));
        return new HostAndPort(host, port);
    }

    @Override
    public Jedis getResource() {
        while (true) {
            Jedis jedis = (Jedis)super.getResource();
            jedis.setDataSource(this);
            HostAndPort master = this.currentHostMaster;
            HostAndPort connection = new HostAndPort(jedis.getClient().getHost(), jedis.getClient().getPort());
            if (master.equals(connection)) {
                return jedis;
            }
            this.returnBrokenResource(jedis);
        }
    }

    @Override
    @Deprecated
    public void returnBrokenResource(Jedis resource) {
        if (resource != null) {
            this.returnBrokenResourceObject(resource);
        }
    }

    @Override
    @Deprecated
    public void returnResource(Jedis resource) {
        if (resource != null) {
            resource.resetState();
            this.returnResourceObject(resource);
        }
    }

    protected class MasterListener
    extends Thread {
        protected String masterName;
        protected String host;
        protected int port;
        protected long subscribeRetryWaitTimeMillis;
        protected volatile Jedis j;
        protected AtomicBoolean running;

        protected MasterListener() {
            this.subscribeRetryWaitTimeMillis = 5000L;
            this.running = new AtomicBoolean(false);
        }

        public MasterListener(String masterName, String host, int port) {
            super(String.format("MasterListener-%s-[%s:%d]", masterName, host, port));
            this.subscribeRetryWaitTimeMillis = 5000L;
            this.running = new AtomicBoolean(false);
            this.masterName = masterName;
            this.host = host;
            this.port = port;
        }

        public MasterListener(String masterName, String host, int port, long subscribeRetryWaitTimeMillis) {
            this(masterName, host, port);
            this.subscribeRetryWaitTimeMillis = subscribeRetryWaitTimeMillis;
        }

        @Override
        public void run() {
            this.running.set(true);
            while (this.running.get()) {
                this.j = new Jedis(this.host, this.port);
                try {
                    if (!this.running.get()) break;
                    this.j.subscribe(new JedisPubSub(){

                        @Override
                        public void onMessage(String channel, String message) {
                            JedisSentinelPool.this.log.fine("Sentinel " + MasterListener.this.host + ":" + MasterListener.this.port + " published: " + message + ".");
                            String[] switchMasterMsg = message.split(" ");
                            if (switchMasterMsg.length > 3) {
                                if (MasterListener.this.masterName.equals(switchMasterMsg[0])) {
                                    JedisSentinelPool.this.initPool(JedisSentinelPool.this.toHostAndPort(Arrays.asList(switchMasterMsg[3], switchMasterMsg[4])));
                                } else {
                                    JedisSentinelPool.this.log.fine("Ignoring message on +switch-master for master name " + switchMasterMsg[0] + ", our master name is " + MasterListener.this.masterName);
                                }
                            } else {
                                JedisSentinelPool.this.log.severe("Invalid message received on Sentinel " + MasterListener.this.host + ":" + MasterListener.this.port + " on channel +switch-master: " + message);
                            }
                        }
                    }, "+switch-master");
                }
                catch (JedisConnectionException e) {
                    if (this.running.get()) {
                        JedisSentinelPool.this.log.log(Level.SEVERE, "Lost connection to Sentinel at " + this.host + ":" + this.port + ". Sleeping 5000ms and retrying.", e);
                        try {
                            Thread.sleep(this.subscribeRetryWaitTimeMillis);
                        }
                        catch (InterruptedException e1) {
                            JedisSentinelPool.this.log.log(Level.SEVERE, "Sleep interrupted: ", e1);
                        }
                        continue;
                    }
                    JedisSentinelPool.this.log.fine("Unsubscribing from Sentinel at " + this.host + ":" + this.port);
                }
                finally {
                    this.j.close();
                }
            }
        }

        public void shutdown() {
            try {
                JedisSentinelPool.this.log.fine("Shutting down listener on " + this.host + ":" + this.port);
                this.running.set(false);
                if (this.j != null) {
                    this.j.disconnect();
                }
            }
            catch (Exception e) {
                JedisSentinelPool.this.log.log(Level.SEVERE, "Caught exception while shutting down: ", e);
            }
        }
    }
}

